/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.query.PinotExpression;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class PinotProjectExpressionConverter
implements RowExpressionVisitor<PinotExpression, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>> {
    private static final Set<String> LOGICAL_BINARY_OPS_FILTER = ImmutableSet.of((Object)"=", (Object)"<", (Object)"<=", (Object)">", (Object)">=", (Object)"<>", (Object[])new String[0]);
    private static final Map<String, String> PRESTO_TO_PINOT_OPERATORS = ImmutableMap.of((Object)"-", (Object)"SUB", (Object)"+", (Object)"ADD", (Object)"*", (Object)"MULT", (Object)"/", (Object)"DIV");
    private static final Set<String> TIME_EQUIVALENT_TYPES = ImmutableSet.of((Object)"bigint", (Object)"integer", (Object)"tinyint", (Object)"smallint");
    protected final TypeManager typeManager;
    protected final FunctionMetadataManager functionMetadataManager;
    protected final StandardFunctionResolution standardFunctionResolution;
    protected final ConnectorSession session;

    public PinotProjectExpressionConverter(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution, ConnectorSession session) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public PinotExpression visitVariableReference(VariableReferenceExpression reference, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        PinotQueryGeneratorContext.Selection input = Objects.requireNonNull(context.get(reference), String.format("Input column %s does not exist in the input", reference));
        return new PinotExpression(input.getDefinition(), input.getOrigin());
    }

    public PinotExpression visitLambda(LambdaDefinitionExpression lambda, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support lambda " + lambda);
    }

    protected boolean isImplicitCast(Type inputType, Type resultType) {
        if (this.typeManager.canCoerce(inputType, resultType)) {
            return true;
        }
        return resultType.getTypeSignature().getBase().equals("timestamp") && TIME_EQUIVALENT_TYPES.contains(inputType.getTypeSignature().getBase());
    }

    protected PinotExpression handleArithmeticExpression(CallExpression expression, OperatorType operatorType, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        List arguments = expression.getArguments();
        if (arguments.size() == 2) {
            PinotExpression left = (PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context);
            PinotExpression right = (PinotExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context);
            String prestoOperator = operatorType.getOperator();
            String pinotOperator = PRESTO_TO_PINOT_OPERATORS.get(prestoOperator);
            if (pinotOperator == null) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unsupported binary expression " + prestoOperator);
            }
            return PinotExpression.derived(String.format("%s(%s, %s)", pinotOperator, left.getDefinition(), right.getDefinition()));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Don't know how to interpret %s as an arithmetic expression", expression));
    }

    protected PinotExpression handleCast(CallExpression cast, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (cast.getArguments().size() == 1) {
            RowExpression input = (RowExpression)cast.getArguments().get(0);
            Type expectedType = cast.getType();
            if (this.isImplicitCast(input.getType(), expectedType)) {
                return (PinotExpression)input.accept((RowExpressionVisitor)this, context);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Non implicit casts not supported: " + cast);
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("This type of CAST operator not supported. Received: %s", cast));
    }

    private PinotExpression handleLogicalBinary(CallExpression call, String operator, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (!LOGICAL_BINARY_OPS_FILTER.contains(operator)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("'%s' is not supported in filter", operator));
        }
        List arguments = call.getArguments();
        if (arguments.size() == 2) {
            return PinotExpression.derived(String.format("(%s %s %s)", this.getExpressionOrConstantString((RowExpression)arguments.get(0), context), operator, this.getExpressionOrConstantString((RowExpression)arguments.get(1), context)));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Unknown logical binary: '%s'", call));
    }

    protected String getExpressionOrConstantString(RowExpression expression, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (expression instanceof ConstantExpression) {
            return new PinotExpression(PinotPushdownUtils.getLiteralAsString((ConstantExpression)expression), PinotQueryGeneratorContext.Origin.LITERAL).getDefinition();
        }
        return ((PinotExpression)expression.accept((RowExpressionVisitor)this, context)).getDefinition();
    }

    public PinotExpression visitInputReference(InputReferenceExpression reference, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support struct dereferencing: " + reference);
    }

    public PinotExpression visitSpecialForm(SpecialFormExpression specialForm, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (!PinotSessionProperties.getPushdownProjectExpressions(this.session)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Special form not supported: " + specialForm);
        }
        switch (specialForm.getForm()) {
            case SWITCH: {
                int numArguments = specialForm.getArguments().size();
                String searchExpression = this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(0), context);
                return PinotExpression.derived(String.format("CASE %s %s ELSE %s END", searchExpression, specialForm.getArguments().subList(1, numArguments - 1).stream().map(argument -> ((PinotExpression)argument.accept((RowExpressionVisitor)this, (Object)context)).getDefinition()).collect(Collectors.joining(" ")), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(numArguments - 1), context)));
            }
            case WHEN: {
                return PinotExpression.derived(String.format("%s %s THEN %s", specialForm.getForm().toString(), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(0), context), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(1), context)));
            }
            case IF: 
            case NULL_IF: 
            case DEREFERENCE: 
            case ROW_CONSTRUCTOR: 
            case BIND: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support the special form" + specialForm);
            }
            case IN: 
            case AND: 
            case OR: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Special form not supported: " + specialForm);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unexpected special form: " + specialForm);
    }

    public PinotExpression visitCall(CallExpression call, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            return this.handleCast(call, context);
        }
        if (!PinotSessionProperties.getPushdownProjectExpressions(this.session)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Call not supported: " + call);
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        Optional operatorType = functionMetadata.getOperatorType();
        if (this.standardFunctionResolution.isComparisonFunction(functionHandle) && operatorType.isPresent()) {
            return this.handleLogicalBinary(call, ((OperatorType)operatorType.get()).getOperator(), context);
        }
        if (this.standardFunctionResolution.isArithmeticFunction(functionHandle) && operatorType.isPresent()) {
            return this.handleArithmeticExpression(call, (OperatorType)operatorType.get(), context);
        }
        if (this.standardFunctionResolution.isNegateFunction(functionHandle)) {
            return PinotExpression.derived('-' + ((PinotExpression)((RowExpression)call.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition());
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Call not supported: " + call);
    }

    public PinotExpression visitConstant(ConstantExpression literal, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Constant not supported: " + literal);
    }
}

