/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.PinotQueryOptionsUtils;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class PinotQueryGeneratorContext {
    public static final String TIME_BOUNDARY_FILTER_TEMPLATE = "__TIME_BOUNDARY_FILTER_TEMPLATE__";
    public static final String TABLE_NAME_SUFFIX_TEMPLATE = "__TABLE_NAME_SUFFIX_TEMPLATE__";
    private final Map<VariableReferenceExpression, Selection> selections;
    private final LinkedHashSet<VariableReferenceExpression> outputs;
    private final LinkedHashSet<VariableReferenceExpression> groupByColumns;
    private final LinkedHashMap<VariableReferenceExpression, OrderingColumnInformation> topNColumnInformationMap;
    private final Set<VariableReferenceExpression> hiddenColumnSet;
    private final Set<VariableReferenceExpression> variablesInAggregation;
    private final Optional<String> from;
    private final Optional<String> filter;
    private final OptionalInt limit;
    private final int aggregations;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selections", this.selections).add("outputs", this.outputs).add("groupByColumns", this.groupByColumns).add("topNColumnInformationMap", this.topNColumnInformationMap).add("hiddenColumnSet", this.hiddenColumnSet).add("variablesInAggregation", this.variablesInAggregation).add("from", this.from).add("filter", this.filter).add("limit", (Object)this.limit).add("aggregations", this.aggregations).toString();
    }

    public PinotQueryGeneratorContext() {
        this(new HashMap<VariableReferenceExpression, Selection>(), new LinkedHashSet<VariableReferenceExpression>(), null);
    }

    PinotQueryGeneratorContext(Map<VariableReferenceExpression, Selection> selections, LinkedHashSet<VariableReferenceExpression> outputs, String from) {
        this(selections, outputs, Optional.ofNullable(from), Optional.empty(), 0, new LinkedHashSet<VariableReferenceExpression>(), new LinkedHashMap<VariableReferenceExpression, OrderingColumnInformation>(), OptionalInt.empty(), new HashSet<VariableReferenceExpression>(), new HashSet<VariableReferenceExpression>());
    }

    private PinotQueryGeneratorContext(Map<VariableReferenceExpression, Selection> selections, LinkedHashSet<VariableReferenceExpression> outputs, Optional<String> from, Optional<String> filter, int aggregations, LinkedHashSet<VariableReferenceExpression> groupByColumns, LinkedHashMap<VariableReferenceExpression, OrderingColumnInformation> topNColumnInformationMap, OptionalInt limit, Set<VariableReferenceExpression> variablesInAggregation, Set<VariableReferenceExpression> hiddenColumnSet) {
        this.selections = new HashMap<VariableReferenceExpression, Selection>(Objects.requireNonNull(selections, "selections can't be null"));
        this.outputs = new LinkedHashSet(Objects.requireNonNull(outputs, "outputs can't be null."));
        this.from = Objects.requireNonNull(from, "source can't be null");
        this.aggregations = aggregations;
        this.groupByColumns = new LinkedHashSet(Objects.requireNonNull(groupByColumns, "groupByColumns can't be null. It could be empty if not available"));
        this.topNColumnInformationMap = new LinkedHashMap(Objects.requireNonNull(topNColumnInformationMap, "topNColumnInformationMap can't be null. It could be empty if not available"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.hiddenColumnSet = Objects.requireNonNull(hiddenColumnSet, "hidden column set is null");
        this.variablesInAggregation = Objects.requireNonNull(variablesInAggregation, "variables in aggregation is null");
    }

    public PinotQueryGeneratorContext withFilter(String filter) {
        PinotPushdownUtils.checkSupported(!this.hasFilter(), "There already exists a filter. Pinot doesn't support filters at multiple levels", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasAggregation(), "Pinot doesn't support filtering the results of aggregation", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Pinot doesn't support filtering on top of the limit", new Object[0]);
        return new PinotQueryGeneratorContext(this.selections, this.outputs, this.from, Optional.of(filter), this.aggregations, this.groupByColumns, this.topNColumnInformationMap, this.limit, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withAggregation(Map<VariableReferenceExpression, Selection> newSelections, LinkedHashSet<VariableReferenceExpression> outputs, LinkedHashSet<VariableReferenceExpression> groupByColumns, int aggregations, Set<VariableReferenceExpression> hiddenColumnSet) {
        AtomicBoolean pushDownDistinctCount = new AtomicBoolean(false);
        LinkedHashSet<VariableReferenceExpression> newOutputs = new LinkedHashSet<VariableReferenceExpression>(outputs);
        newSelections.values().forEach(selection -> {
            if (selection.getDefinition().startsWith("distinctCount".toUpperCase(Locale.ENGLISH))) {
                pushDownDistinctCount.set(true);
            }
        });
        if (pushDownDistinctCount.get()) {
            hiddenColumnSet = ImmutableSet.of();
        } else {
            PinotPushdownUtils.checkSupported(!this.hasAggregation(), "Pinot doesn't support aggregation on top of the aggregated data", new Object[0]);
        }
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Pinot doesn't support aggregation on top of the limit", new Object[0]);
        return new PinotQueryGeneratorContext(newSelections, newOutputs, this.from, this.filter, aggregations, groupByColumns, this.topNColumnInformationMap, this.limit, this.variablesInAggregation, (Set<VariableReferenceExpression>)hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withProject(Map<VariableReferenceExpression, Selection> newSelections, LinkedHashSet<VariableReferenceExpression> newOutputs) {
        PinotPushdownUtils.checkSupported(!newOutputs.isEmpty(), "Missing output expression in Pinot query context", new Object[0]);
        return new PinotQueryGeneratorContext(newSelections, newOutputs, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnInformationMap, this.limit, this.variablesInAggregation, this.hiddenColumnSet);
    }

    private static int checkForValidLimit(long limit) {
        if (limit <= 0L || limit > Integer.MAX_VALUE) {
            throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Limit " + limit + " not supported: Limit is not being pushed down");
        }
        return StrictMath.toIntExact(limit);
    }

    public PinotQueryGeneratorContext withLimit(long limit) {
        int intLimit = PinotQueryGeneratorContext.checkForValidLimit(limit);
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Limit already exists. Pinot doesn't support limit on top of another limit", new Object[0]);
        return new PinotQueryGeneratorContext(this.selections, this.outputs, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnInformationMap, OptionalInt.of(intLimit), this.variablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withTopN(LinkedHashMap<VariableReferenceExpression, SortOrder> orderByColumnOrderingMap, long limit) {
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Limit already exists. Pinot doesn't support order by limit on top of another limit", new Object[0]);
        int intLimit = PinotQueryGeneratorContext.checkForValidLimit(limit);
        LinkedHashMap<VariableReferenceExpression, OrderingColumnInformation> orderByColumnInformation = new LinkedHashMap<VariableReferenceExpression, OrderingColumnInformation>();
        orderByColumnOrderingMap.entrySet().stream().forEach(entry -> orderByColumnInformation.put((VariableReferenceExpression)entry.getKey(), new OrderingColumnInformation((SortOrder)entry.getValue(), this.selections.get(entry.getKey()))));
        return new PinotQueryGeneratorContext(this.selections, this.outputs, this.from, this.filter, this.aggregations, this.groupByColumns, orderByColumnInformation, OptionalInt.of(intLimit), this.variablesInAggregation, this.hiddenColumnSet);
    }

    private boolean hasFilter() {
        return this.filter.isPresent();
    }

    private boolean hasLimit() {
        return this.limit.isPresent();
    }

    public boolean hasGroupBy() {
        return !this.groupByColumns.isEmpty();
    }

    public boolean hasAggregation() {
        return this.aggregations > 0;
    }

    private boolean hasOrderBy() {
        return !this.topNColumnInformationMap.isEmpty();
    }

    public Map<VariableReferenceExpression, Selection> getSelections() {
        return this.selections;
    }

    public Set<VariableReferenceExpression> getHiddenColumnSet() {
        return this.hiddenColumnSet;
    }

    Set<VariableReferenceExpression> getVariablesInAggregation() {
        return this.variablesInAggregation;
    }

    public PinotQueryGenerator.GeneratedPinotQuery toQuery(PinotConfig pinotConfig, ConnectorSession session) {
        return this.toSqlQuery(pinotConfig, session);
    }

    private String generatePinotQueryHelper(boolean forBroker, String expressions, String tableName, String limitClause, String queryOptions) {
        String query = "SELECT " + expressions + " FROM " + tableName + (forBroker ? "" : TABLE_NAME_SUFFIX_TEMPLATE);
        if (this.filter.isPresent()) {
            String filterString = this.filter.get();
            query = query + String.format(" WHERE %s%s", filterString, forBroker ? "" : TIME_BOUNDARY_FILTER_TEMPLATE);
        } else if (!forBroker) {
            query = query + TIME_BOUNDARY_FILTER_TEMPLATE;
        }
        if (this.hasGroupBy()) {
            String groupByExpr = this.groupByColumns.stream().map(x -> this.selections.get(x).getDefinition()).collect(Collectors.joining(", "));
            query = query + " GROUP BY " + groupByExpr;
        }
        if (this.hasOrderBy()) {
            String orderByExpressions = this.topNColumnInformationMap.entrySet().stream().map(entry -> ((OrderingColumnInformation)entry.getValue()).getSelection().getDefinition() + (((OrderingColumnInformation)entry.getValue()).getSortOrder().isAscending() ? "" : " DESC")).collect(Collectors.joining(", "));
            query = query + " ORDER BY " + orderByExpressions;
        }
        query = query + limitClause;
        query = query + queryOptions;
        return query;
    }

    public PinotQueryGenerator.GeneratedPinotQuery toSqlQuery(PinotConfig pinotConfig, ConnectorSession session) {
        int nonAggregateShortQueryLimit = PinotSessionProperties.getNonAggregateLimitForBrokerQueries(session);
        boolean isQueryShort = this.hasAggregation() || this.hasGroupBy() || this.limit.orElse(Integer.MAX_VALUE) < nonAggregateShortQueryLimit;
        boolean attemptBrokerQueries = PinotSessionProperties.isAttemptBrokerQueries(session) || isQueryShort;
        boolean forBroker = !PinotSessionProperties.isForbidBrokerQueries(session) && attemptBrokerQueries;
        String groupByExpressions = this.groupByColumns.stream().map(x -> this.selections.get(x).getDefinition()).collect(Collectors.joining(", "));
        PinotPushdownUtils.checkSupported(!this.outputs.isEmpty(), "Unable to generate Pinot query without output expression", new Object[0]);
        String selectExpressions = this.outputs.stream().filter(o -> !this.groupByColumns.contains(o)).map(o -> this.updateSelection(this.selections.get(o).getDefinition(), session)).collect(Collectors.joining(", "));
        String expressions = groupByExpressions.isEmpty() ? selectExpressions : (selectExpressions.isEmpty() ? groupByExpressions : groupByExpressions + ", " + selectExpressions);
        String tableName = this.from.orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Table name not encountered yet"));
        int queryLimit = -1;
        if (!this.hasAggregation() && !this.hasGroupBy()) {
            if (!this.limit.isPresent() && forBroker && !attemptBrokerQueries) {
                throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Broker non aggregate queries have to have a limit");
            }
            queryLimit = this.limit.orElse(PinotSessionProperties.getLimitLargerForSegment(session));
        } else if (this.hasGroupBy()) {
            queryLimit = this.limit.isPresent() ? this.limit.getAsInt() : PinotSessionProperties.getTopNLarge(session);
        }
        String limitClause = "";
        if (queryLimit > 0) {
            limitClause = " LIMIT " + queryLimit;
        }
        String queryOptionsProperty = PinotSessionProperties.getQueryOptions(session);
        String queryOptions = PinotQueryOptionsUtils.getQueryOptionsAsString(queryOptionsProperty);
        String query = this.generatePinotQueryHelper(forBroker, expressions, tableName, limitClause, queryOptions);
        LinkedHashMap<VariableReferenceExpression, PinotColumnHandle> assignments = this.getAssignments();
        List<Integer> indices = this.getIndicesMappingFromPinotSchemaToPrestoSchema(query, assignments);
        return new PinotQueryGenerator.GeneratedPinotQuery(tableName, query, indices, this.filter.isPresent(), forBroker);
    }

    private String updateSelection(String definition, ConnectorSession session) {
        String overrideDistinctCountFunction = PinotSessionProperties.getOverrideDistinctCountFunction(session);
        if (!"distinctCount".equalsIgnoreCase(overrideDistinctCountFunction)) {
            return definition.replaceFirst("distinctCount".toUpperCase() + "\\(", overrideDistinctCountFunction.toUpperCase() + "\\(");
        }
        return definition;
    }

    private List<Integer> getIndicesMappingFromPinotSchemaToPrestoSchema(String query, Map<VariableReferenceExpression, PinotColumnHandle> assignments) {
        LinkedHashMap<VariableReferenceExpression, Selection> expressionsInPinotOrder = new LinkedHashMap<VariableReferenceExpression, Selection>();
        for (VariableReferenceExpression groupByColumn : this.groupByColumns) {
            Selection groupByColumnDefinition = this.selections.get(groupByColumn);
            if (groupByColumnDefinition == null) {
                throw new IllegalStateException(String.format("Group By column (%s) definition not found in input selections: %s", groupByColumn, Joiner.on((String)",").withKeyValueSeparator(":").join(this.selections)));
            }
            expressionsInPinotOrder.put(groupByColumn, groupByColumnDefinition);
        }
        for (VariableReferenceExpression outputColumn : this.outputs) {
            Selection outputColumnDefinition = this.selections.get(outputColumn);
            if (outputColumnDefinition == null) {
                throw new IllegalStateException(String.format("Output column (%s) definition not found in input selections: %s", outputColumn, Joiner.on((String)",").withKeyValueSeparator(":").join(this.selections)));
            }
            expressionsInPinotOrder.put(outputColumn, outputColumnDefinition);
        }
        PinotPushdownUtils.checkSupported((long)assignments.size() <= expressionsInPinotOrder.keySet().stream().filter(key -> !this.hiddenColumnSet.contains(key)).count(), "Expected returned expressions %s is a superset of selections %s", Joiner.on((String)",").withKeyValueSeparator(":").join(expressionsInPinotOrder), Joiner.on((String)",").withKeyValueSeparator("=").join(assignments));
        HashMap<VariableReferenceExpression, Integer> assignmentToIndex = new HashMap<VariableReferenceExpression, Integer>();
        Iterator<Map.Entry<VariableReferenceExpression, PinotColumnHandle>> assignmentsIterator = assignments.entrySet().iterator();
        for (int i = 0; i < assignments.size(); ++i) {
            VariableReferenceExpression key2 = assignmentsIterator.next().getKey();
            Integer previous = assignmentToIndex.put(key2, i);
            if (previous == null) continue;
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.of(query), String.format("Expected Pinot column handle %s to occur only once, but we have: %s", key2, Joiner.on((String)",").withKeyValueSeparator("=").join(assignments)));
        }
        ImmutableList.Builder outputIndices = ImmutableList.builder();
        for (Map.Entry expression : expressionsInPinotOrder.entrySet()) {
            Integer index = this.hiddenColumnSet.contains(expression.getKey()) ? Integer.valueOf(-1) : assignmentToIndex.getOrDefault(expression.getKey(), -1);
            outputIndices.add((Object)index);
        }
        return outputIndices.build();
    }

    public LinkedHashMap<VariableReferenceExpression, PinotColumnHandle> getAssignments() {
        LinkedHashMap<VariableReferenceExpression, PinotColumnHandle> result = new LinkedHashMap<VariableReferenceExpression, PinotColumnHandle>();
        LinkedHashSet outputFields = new LinkedHashSet();
        outputFields.addAll(this.outputs.stream().filter(variable -> !this.hiddenColumnSet.contains(variable)).collect(Collectors.toList()));
        outputFields.stream().forEach(variable -> {
            Selection selection = this.selections.get(variable);
            PinotColumnHandle handle = selection.getOrigin() == Origin.TABLE_COLUMN ? new PinotColumnHandle(selection.getDefinition(), variable.getType(), PinotColumnHandle.PinotColumnType.REGULAR) : new PinotColumnHandle((VariableReferenceExpression)variable, PinotColumnHandle.PinotColumnType.DERIVED);
            result.put((VariableReferenceExpression)variable, handle);
        });
        return result;
    }

    public PinotQueryGeneratorContext withOutputColumns(List<VariableReferenceExpression> outputColumns) {
        LinkedHashSet<VariableReferenceExpression> newOutputs = new LinkedHashSet<VariableReferenceExpression>(outputColumns);
        outputColumns.forEach(o -> Objects.requireNonNull(this.selections.get(o), String.format("Cannot find the selection %s in the original context %s", o, this)));
        this.selections.entrySet().stream().filter(e -> this.hiddenColumnSet.contains(e.getKey())).forEach(e -> newOutputs.add((VariableReferenceExpression)e.getKey()));
        return new PinotQueryGeneratorContext(this.selections, newOutputs, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnInformationMap, this.limit, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withVariablesInAggregation(Set<VariableReferenceExpression> newVariablesInAggregation) {
        return new PinotQueryGeneratorContext(this.selections, this.outputs, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnInformationMap, this.limit, newVariablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withDistinctLimit(LinkedHashSet<VariableReferenceExpression> newGroupByColumns, long limit) {
        int intLimit = PinotQueryGeneratorContext.checkForValidLimit(limit);
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Limit already exists. Pinot doesn't support limit on top of another limit", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasGroupBy(), "GroupBy already exists. Pinot doesn't support Distinct on top of another Group By", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasAggregation(), "Aggregation already exists. Pinot doesn't support Distinct Limit on top of Aggregation", new Object[0]);
        return new PinotQueryGeneratorContext(this.selections, this.outputs, this.from, this.filter, this.aggregations, newGroupByColumns, this.topNColumnInformationMap, OptionalInt.of(intLimit), this.variablesInAggregation, this.hiddenColumnSet);
    }

    private static class OrderingColumnInformation {
        private final SortOrder sortOrder;
        private final Selection selection;

        public OrderingColumnInformation(SortOrder sortOrder, Selection selection) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
            this.selection = Objects.requireNonNull(selection, "selection is null");
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public Selection getSelection() {
            return this.selection;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sortOrder", (Object)(this.sortOrder.isAscending() ? "ASC" : "DESC")).add("selection", (Object)this.selection).toString();
        }
    }

    public static class Selection {
        private final String definition;
        private final Origin origin;

        public Selection(String definition, Origin origin) {
            this.origin = origin;
            this.definition = origin == Origin.TABLE_COLUMN ? (definition.startsWith("\"") ? definition : String.format("\"%s\"", definition)) : definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public Origin getOrigin() {
            return this.origin;
        }

        public String toString() {
            return this.definition;
        }
    }

    public static enum Origin {
        TABLE_COLUMN,
        DERIVED,
        LITERAL;

    }
}

