/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.http.client.Request;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotUtils;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class PinotBrokerPageSourceBase
implements ConnectorPageSource {
    private static final String PINOT_INFINITY = "\u221e";
    private static final String PINOT_POSITIVE_INFINITY = "+\u221e";
    private static final String PINOT_NEGATIVE_INFINITY = "-\u221e";
    private static final Double PRESTO_INFINITY = Double.POSITIVE_INFINITY;
    private static final Double PRESTO_NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final PinotConfig pinotConfig;
    protected final List<PinotColumnHandle> columnHandles;
    protected final PinotClusterInfoFetcher clusterInfoFetcher;
    protected final ConnectorSession session;
    protected final ObjectMapper objectMapper;
    protected boolean finished;
    protected long readTimeNanos;
    protected long completedBytes;

    public PinotBrokerPageSourceBase(PinotConfig pinotConfig, ConnectorSession session, List<PinotColumnHandle> columnHandles, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinot config is null");
        this.clusterInfoFetcher = Objects.requireNonNull(clusterInfoFetcher, "cluster info fetcher is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
        this.session = Objects.requireNonNull(session, "session is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper is null");
    }

    private static Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ne) {
            switch (value) {
                case "\u221e": 
                case "+\u221e": {
                    return PRESTO_INFINITY;
                }
                case "-\u221e": {
                    return PRESTO_NEGATIVE_INFINITY;
                }
            }
            throw new PinotException(PinotErrorCode.PINOT_DECODE_ERROR, Optional.empty(), "Cannot decode double value from pinot " + value, ne);
        }
    }

    protected void setValue(Type type, BlockBuilder blockBuilder, JsonNode value) {
        if (blockBuilder == null) {
            return;
        }
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkState((boolean)value.isArray());
            BlockBuilder childBuilder = blockBuilder.beginBlockEntry();
            ArrayNode arrayNode = (ArrayNode)value;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.setValue(((ArrayType)type).getElementType(), childBuilder, PinotBrokerPageSourceBase.asText(arrayNode.get(i)));
            }
            blockBuilder.closeEntry();
        } else {
            this.setValue(type, blockBuilder, PinotBrokerPageSourceBase.asText(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setValue(Type type, BlockBuilder blockBuilder, String value) {
        if (blockBuilder == null) {
            return;
        }
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (!(type instanceof FixedWidthType) && !(type instanceof VarcharType)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
        }
        if (type instanceof FixedWidthType) {
            this.completedBytes += (long)((FixedWidthType)type).getFixedSize();
            if (type instanceof BigintType) {
                type.writeLong(blockBuilder, PinotBrokerPageSourceBase.parseDouble(value).longValue());
                return;
            } else if (type instanceof IntegerType) {
                blockBuilder.writeInt(PinotBrokerPageSourceBase.parseDouble(value).intValue());
                return;
            } else if (type instanceof TinyintType) {
                blockBuilder.writeByte((int)PinotBrokerPageSourceBase.parseDouble(value).byteValue());
                return;
            } else if (type instanceof SmallintType) {
                blockBuilder.writeShort((int)PinotBrokerPageSourceBase.parseDouble(value).shortValue());
                return;
            } else if (type instanceof BooleanType) {
                type.writeBoolean(blockBuilder, Boolean.parseBoolean(value));
                return;
            } else if (type instanceof DecimalType || type instanceof DoubleType) {
                type.writeDouble(blockBuilder, PinotBrokerPageSourceBase.parseDouble(value).doubleValue());
                return;
            } else if (type instanceof TimestampType) {
                type.writeLong(blockBuilder, Long.parseLong(value));
                return;
            } else {
                if (!(type instanceof DateType)) throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
                type.writeLong(blockBuilder, Long.parseLong(value));
            }
            return;
        } else {
            Slice slice = Slices.utf8Slice((String)value);
            blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
            this.completedBytes += (long)slice.length();
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        long start = System.nanoTime();
        try {
            BlockAndTypeBuilder blockAndTypeBuilder = this.buildBlockAndTypeBuilder(this.columnHandles, this.getBrokerQuery());
            int counter = this.issueQueryAndPopulate(this.getBrokerQuery(), Collections.unmodifiableList(blockAndTypeBuilder.getColumnBlockBuilders()), Collections.unmodifiableList(blockAndTypeBuilder.getColumnTypes()));
            PageBuilder pageBuilder = blockAndTypeBuilder.getPageBuilder();
            pageBuilder.declarePositions(counter);
            Page page = pageBuilder.build();
            this.finished = true;
            Page page2 = page;
            return page2;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - start;
        }
    }

    protected abstract PinotQueryGenerator.GeneratedPinotQuery getBrokerQuery();

    protected void setRows(String query, List<BlockBuilder> blockBuilders, List<Type> types, JsonNode rows) {
        for (int rowNumber = 0; rowNumber < rows.size(); ++rowNumber) {
            JsonNode result = rows.get(rowNumber);
            if (result == null || result.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(query), String.format("Expected row of %d columns", blockBuilders.size()));
            }
            for (int columnNumber = 0; columnNumber < blockBuilders.size(); ++columnNumber) {
                this.setValue(types.get(columnNumber), blockBuilders.get(columnNumber), result.get(columnNumber));
            }
        }
    }

    protected static void handleCommonResponse(String pql, JsonNode jsonBody) {
        JsonNode numServersResponded = jsonBody.get("numServersResponded");
        JsonNode numServersQueried = jsonBody.get("numServersQueried");
        if (numServersQueried == null || numServersResponded == null || numServersQueried.asInt() > numServersResponded.asInt()) {
            throw new PinotException(PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, Optional.of(pql), String.format("Only %s out of %s servers responded for query %s", numServersResponded.asInt(), numServersQueried.asInt(), pql));
        }
        JsonNode exceptions = jsonBody.get("exceptions");
        if (exceptions != null && exceptions.isArray() && exceptions.size() > 0) {
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(pql), String.format("Query %s encountered exception %s", pql, exceptions.get(0)));
        }
    }

    protected static String asText(JsonNode node) {
        if (node.isArray()) {
            Object[] results = new String[node.size()];
            for (int i = 0; i < node.size(); ++i) {
                results[i] = PinotBrokerPageSourceBase.asText(node.get(i));
            }
            return Arrays.toString(results);
        }
        Preconditions.checkState((boolean)node.isValueNode());
        return node.isNull() ? null : node.asText();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.finished = true;
    }

    protected int issueQueryAndPopulate(PinotQueryGenerator.GeneratedPinotQuery pinotQuery, List<BlockBuilder> blockBuilders, List<Type> types) {
        return PinotUtils.doWithRetries(PinotSessionProperties.getPinotRetryCount(this.session), retryNumber -> {
            Optional<String> rpcService;
            String queryHost;
            if (this.pinotConfig.getRestProxyUrl() != null) {
                queryHost = this.pinotConfig.getRestProxyUrl();
                rpcService = Optional.ofNullable(this.pinotConfig.getRestProxyServiceForQuery());
            } else {
                queryHost = this.clusterInfoFetcher.getBrokerHost(pinotQuery.getTable());
                rpcService = Optional.empty();
            }
            Request.Builder builder = Request.Builder.preparePost().setUri(URI.create(String.format(this.getQueryUrlTemplate(), queryHost)));
            String body = this.clusterInfoFetcher.doHttpActionWithHeaders(builder, Optional.of(this.getRequestPayload(pinotQuery)), rpcService);
            return this.populateFromQueryResults(pinotQuery, blockBuilders, types, body);
        });
    }

    String getRequestPayload(PinotQueryGenerator.GeneratedPinotQuery pinotQuery) {
        ImmutableMap pinotRequest = ImmutableMap.of((Object)this.getRequestPayloadKey(), (Object)pinotQuery.getQuery());
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)pinotRequest);
        }
        catch (JsonProcessingException e) {
            throw new PinotException(PinotErrorCode.PINOT_REQUEST_GENERATOR_FAILURE, Optional.of(pinotQuery.getQuery()), "Unable to Jsonify request: " + Arrays.toString(pinotRequest.entrySet().toArray()), e);
        }
    }

    abstract String getQueryUrlTemplate();

    abstract String getRequestPayloadKey();

    abstract int populateFromQueryResults(PinotQueryGenerator.GeneratedPinotQuery var1, List<BlockBuilder> var2, List<Type> var3, String var4);

    abstract BlockAndTypeBuilder buildBlockAndTypeBuilder(List<PinotColumnHandle> var1, PinotQueryGenerator.GeneratedPinotQuery var2);

    public static class BlockAndTypeBuilder {
        private final PageBuilder pageBuilder;
        private final List<BlockBuilder> columnBlockBuilders;
        private final List<Type> columnTypes;

        public BlockAndTypeBuilder(List<Type> columnTypes) {
            this.columnTypes = columnTypes;
            this.pageBuilder = new PageBuilder(columnTypes);
            this.columnBlockBuilders = new ArrayList<BlockBuilder>();
            for (int columnIndex = 0; columnIndex < columnTypes.size(); ++columnIndex) {
                this.columnBlockBuilders.add(this.pageBuilder.getBlockBuilder(columnIndex));
            }
        }

        public BlockAndTypeBuilder(PageBuilder pageBuilder, List<BlockBuilder> columnBlockBuilders, List<Type> columnTypes) {
            this.pageBuilder = pageBuilder;
            this.columnBlockBuilders = columnBlockBuilders;
            this.columnTypes = columnTypes;
        }

        public PageBuilder getPageBuilder() {
            return this.pageBuilder;
        }

        public List<BlockBuilder> getColumnBlockBuilders() {
            return this.columnBlockBuilders;
        }

        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }
    }
}

