/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.pinot.PinotBrokerPageSourceBase;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PinotBrokerPageSourceSql
extends PinotBrokerPageSourceBase {
    private static final String REQUEST_PAYLOAD_KEY = "sql";
    private static final String QUERY_URL_TEMPLATE = "http://%s/query/sql";
    private final PinotQueryGenerator.GeneratedPinotQuery brokerSql;

    public PinotBrokerPageSourceSql(PinotConfig pinotConfig, ConnectorSession session, PinotQueryGenerator.GeneratedPinotQuery brokerSql, List<PinotColumnHandle> columnHandles, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper) {
        super(pinotConfig, session, columnHandles, clusterInfoFetcher, objectMapper);
        this.brokerSql = Objects.requireNonNull(brokerSql, "broker is null");
    }

    @Override
    protected PinotQueryGenerator.GeneratedPinotQuery getBrokerQuery() {
        return this.brokerSql;
    }

    @Override
    String getQueryUrlTemplate() {
        return QUERY_URL_TEMPLATE;
    }

    @Override
    String getRequestPayloadKey() {
        return REQUEST_PAYLOAD_KEY;
    }

    @Override
    @VisibleForTesting
    public int populateFromQueryResults(PinotQueryGenerator.GeneratedPinotQuery pinotQuery, List<BlockBuilder> blockBuilders, List<Type> types, String responseJsonString) {
        JsonNode jsonBody;
        String sql = pinotQuery.getQuery();
        try {
            jsonBody = this.objectMapper.readTree(responseJsonString);
        }
        catch (IOException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), "Couldn't parse response", e);
        }
        PinotBrokerPageSourceSql.handleCommonResponse(sql, jsonBody);
        JsonNode resultTable = jsonBody.get("resultTable");
        if (resultTable != null) {
            JsonNode dataSchema = resultTable.get("dataSchema");
            if (dataSchema == null) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("Expected data schema in the response", new Object[0]));
            }
            JsonNode columnDataTypes = dataSchema.get("columnDataTypes");
            JsonNode columnNames = dataSchema.get("columnNames");
            if (columnDataTypes == null || !columnDataTypes.isArray() || columnDataTypes.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("ColumnDataTypes and results expected for %s, expected %d columnDataTypes but got %d", sql, blockBuilders.size(), columnDataTypes == null ? 0 : columnDataTypes.size()));
            }
            if (columnNames == null || !columnNames.isArray() || columnNames.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("ColumnNames and results expected for %s, expected %d columnNames but got %d", sql, blockBuilders.size(), columnNames == null ? 0 : columnNames.size()));
            }
            JsonNode rows = resultTable.get("rows");
            Preconditions.checkState((rows.size() >= 1 ? 1 : 0) != 0, (Object)"Expected at least one row to be present");
            this.setRows(sql, blockBuilders, types, rows);
            return rows.size();
        }
        throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), "Expected resultTable to be present");
    }

    @Override
    @VisibleForTesting
    public PinotBrokerPageSourceBase.BlockAndTypeBuilder buildBlockAndTypeBuilder(List<PinotColumnHandle> columnHandles, PinotQueryGenerator.GeneratedPinotQuery brokerSql) {
        List<Type> columnTypes = columnHandles.stream().map(PinotColumnHandle::getDataType).collect(Collectors.toList());
        return new PinotBrokerPageSourceBase.BlockAndTypeBuilder(columnTypes);
    }
}

