/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class PinotColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type dataType;
    private final PinotColumnType type;

    public PinotColumnHandle(VariableReferenceExpression variable, PinotColumnType type) {
        this(variable.getName(), variable.getType(), type);
    }

    @JsonCreator
    public PinotColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="dataType") Type dataType, @JsonProperty(value="type") PinotColumnType type) {
        this.columnName = Objects.requireNonNull(columnName, "column name is null");
        this.dataType = Objects.requireNonNull(dataType, "data type name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="dataType")
    public Type getDataType() {
        return this.dataType;
    }

    @JsonProperty
    public PinotColumnType getType() {
        return this.type;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.getColumnName(), this.getDataType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotColumnHandle that = (PinotColumnHandle)o;
        return Objects.equals(this.getColumnName(), that.getColumnName());
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).add("type", (Object)this.type).toString();
    }

    public static enum PinotColumnType {
        REGULAR,
        DERIVED;

    }
}

