/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.configuration.Config;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class PinotConfig {
    public static final int DEFAULT_LIMIT_LARGE_FOR_SEGMENT = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_BACKLOG_PER_SERVER = 30;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_SERVER = 30;
    public static final int DEFAULT_MIN_CONNECTIONS_PER_SERVER = 10;
    public static final int DEFAULT_THREAD_POOL_SIZE = 30;
    public static final int DEFAULT_NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES = 25000;
    public static final int DEFAULT_TOPN_LARGE = 10000;
    private static final Duration DEFAULT_IDLE_TIMEOUT = new Duration(5.0, TimeUnit.MINUTES);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = new Duration(1.0, TimeUnit.MINUTES);
    private static final int DEFAULT_ESTIMATED_SIZE_IN_BYTES_FOR_NON_NUMERIC_COLUMN = 20;
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator(":");
    private int maxConnectionsPerServer = 30;
    private String controllerRestService;
    private String serviceHeaderParam = "RPC-Service";
    private String callerHeaderValue = "presto";
    private String callerHeaderParam = "RPC-Caller";
    private List<String> controllerUrls = ImmutableList.of();
    private String restProxyUrl;
    private String restProxyServiceForQuery;
    private int limitLargeForSegment = Integer.MAX_VALUE;
    private int topNLarge = 10000;
    private Duration idleTimeout = DEFAULT_IDLE_TIMEOUT;
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private int threadPoolSize = 30;
    private int minConnectionsPerServer = 10;
    private int maxBacklogPerServer = 30;
    private int estimatedSizeInBytesForNonNumericColumn = 20;
    private Map<String, String> extraHttpHeaders = ImmutableMap.of();
    private Duration metadataCacheExpiry = new Duration(2.0, TimeUnit.MINUTES);
    private boolean allowMultipleAggregations = true;
    private boolean forbidBrokerQueries;
    private boolean forbidSegmentQueries;
    private boolean inferDateTypeInSchema = true;
    private boolean inferTimestampTypeInSchema = true;
    private boolean markDataFetchExceptionsAsRetriable = true;
    private boolean usePinotSqlForBrokerQueries = true;
    private int numSegmentsPerSplit = 1;
    private boolean ignoreEmptyResponses;
    private int fetchRetryCount = 2;
    private boolean useDateTrunc;
    private int nonAggregateLimitForBrokerQueries = 25000;
    private boolean pushdownTopNBrokerQueries;

    @NotNull
    public Map<String, String> getExtraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Config(value="pinot.extra-http-headers")
    public PinotConfig setExtraHttpHeaders(String headers) {
        this.extraHttpHeaders = ImmutableMap.copyOf((Map)MAP_SPLITTER.split((CharSequence)headers));
        return this;
    }

    @NotNull
    public List<String> getControllerUrls() {
        return this.controllerUrls;
    }

    @Config(value="pinot.controller-urls")
    public PinotConfig setControllerUrls(String controllerUrl) {
        this.controllerUrls = LIST_SPLITTER.splitToList((CharSequence)controllerUrl);
        return this;
    }

    @Nullable
    public String getRestProxyUrl() {
        return this.restProxyUrl;
    }

    @Config(value="pinot.rest-proxy-url")
    public PinotConfig setRestProxyUrl(String restProxyUrl) {
        this.restProxyUrl = restProxyUrl;
        return this;
    }

    @Nullable
    public String getControllerRestService() {
        return this.controllerRestService;
    }

    @Config(value="pinot.controller-rest-service")
    public PinotConfig setControllerRestService(String controllerRestService) {
        this.controllerRestService = controllerRestService;
        return this;
    }

    @NotNull
    public boolean isAllowMultipleAggregations() {
        return this.allowMultipleAggregations;
    }

    @Config(value="pinot.allow-multiple-aggregations")
    public PinotConfig setAllowMultipleAggregations(boolean allowMultipleAggregations) {
        this.allowMultipleAggregations = allowMultipleAggregations;
        return this;
    }

    @NotNull
    public int getLimitLargeForSegment() {
        return this.limitLargeForSegment;
    }

    @Config(value="pinot.limit-large-for-segment")
    public PinotConfig setLimitLargeForSegment(int limitLargeForSegment) {
        this.limitLargeForSegment = limitLargeForSegment;
        return this;
    }

    @NotNull
    public int getTopNLarge() {
        return this.topNLarge;
    }

    @Config(value="pinot.topn-large")
    public PinotConfig setTopNLarge(int topNLarge) {
        this.topNLarge = topNLarge;
        return this;
    }

    @NotNull
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Config(value="pinot.thread-pool-size")
    public PinotConfig setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    @NotNull
    public int getMinConnectionsPerServer() {
        return this.minConnectionsPerServer;
    }

    @Config(value="pinot.min-connections-per-server")
    public PinotConfig setMinConnectionsPerServer(int minConnectionsPerServer) {
        this.minConnectionsPerServer = minConnectionsPerServer;
        return this;
    }

    @NotNull
    public int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="pinot.max-connections-per-server")
    public PinotConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    @NotNull
    public int getMaxBacklogPerServer() {
        return this.maxBacklogPerServer;
    }

    @Config(value="pinot.max-backlog-per-server")
    public PinotConfig setMaxBacklogPerServer(int maxBacklogPerServer) {
        this.maxBacklogPerServer = maxBacklogPerServer;
        return this;
    }

    @MinDuration(value="15s")
    @NotNull
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="pinot.idle-timeout")
    public PinotConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @MinDuration(value="15s")
    @NotNull
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="pinot.connection-timeout")
    public PinotConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @MinDuration(value="0s")
    @NotNull
    public Duration getMetadataCacheExpiry() {
        return this.metadataCacheExpiry;
    }

    @Config(value="pinot.metadata-expiry")
    public PinotConfig setMetadataCacheExpiry(Duration metadataCacheExpiry) {
        this.metadataCacheExpiry = metadataCacheExpiry;
        return this;
    }

    @NotNull
    public int getEstimatedSizeInBytesForNonNumericColumn() {
        return this.estimatedSizeInBytesForNonNumericColumn;
    }

    @Config(value="pinot.estimated-size-in-bytes-for-non-numeric-column")
    public PinotConfig setEstimatedSizeInBytesForNonNumericColumn(int estimatedSizeInBytesForNonNumericColumn) {
        this.estimatedSizeInBytesForNonNumericColumn = estimatedSizeInBytesForNonNumericColumn;
        return this;
    }

    @NotNull
    public String getServiceHeaderParam() {
        return this.serviceHeaderParam;
    }

    @Config(value="pinot.service-header-param")
    public PinotConfig setServiceHeaderParam(String serviceHeaderParam) {
        this.serviceHeaderParam = serviceHeaderParam;
        return this;
    }

    @NotNull
    public String getCallerHeaderValue() {
        return this.callerHeaderValue;
    }

    @Config(value="pinot.caller-header-value")
    public PinotConfig setCallerHeaderValue(String callerHeaderValue) {
        this.callerHeaderValue = callerHeaderValue;
        return this;
    }

    @NotNull
    public String getCallerHeaderParam() {
        return this.callerHeaderParam;
    }

    @Config(value="pinot.caller-header-param")
    public PinotConfig setCallerHeaderParam(String callerHeaderParam) {
        this.callerHeaderParam = callerHeaderParam;
        return this;
    }

    public boolean isForbidBrokerQueries() {
        return this.forbidBrokerQueries;
    }

    @Config(value="pinot.forbid-broker-queries")
    public PinotConfig setForbidBrokerQueries(boolean forbidBrokerQueries) {
        this.forbidBrokerQueries = forbidBrokerQueries;
        return this;
    }

    public boolean isForbidSegmentQueries() {
        return this.forbidSegmentQueries;
    }

    @Config(value="pinot.forbid-segment-queries")
    public PinotConfig setForbidSegmentQueries(boolean forbidSegmentQueries) {
        this.forbidSegmentQueries = forbidSegmentQueries;
        return this;
    }

    @Nullable
    public String getRestProxyServiceForQuery() {
        return this.restProxyServiceForQuery;
    }

    @Config(value="pinot.rest-proxy-service-for-query")
    public PinotConfig setRestProxyServiceForQuery(String restProxyServiceForQuery) {
        this.restProxyServiceForQuery = restProxyServiceForQuery;
        return this;
    }

    public boolean isUseDateTrunc() {
        return this.useDateTrunc;
    }

    @Config(value="pinot.use-date-trunc")
    public PinotConfig setUseDateTrunc(boolean useDateTrunc) {
        this.useDateTrunc = useDateTrunc;
        return this;
    }

    public int getNumSegmentsPerSplit() {
        return this.numSegmentsPerSplit;
    }

    @Config(value="pinot.num-segments-per-split")
    public PinotConfig setNumSegmentsPerSplit(int numSegmentsPerSplit) {
        Preconditions.checkArgument((numSegmentsPerSplit > 0 ? 1 : 0) != 0, (Object)"Number of segments per split must be more than zero");
        this.numSegmentsPerSplit = numSegmentsPerSplit;
        return this;
    }

    public boolean isIgnoreEmptyResponses() {
        return this.ignoreEmptyResponses;
    }

    @Config(value="pinot.ignore-empty-responses")
    public PinotConfig setIgnoreEmptyResponses(boolean ignoreEmptyResponses) {
        this.ignoreEmptyResponses = ignoreEmptyResponses;
        return this;
    }

    public int getFetchRetryCount() {
        return this.fetchRetryCount;
    }

    @Config(value="pinot.fetch-retry-count")
    public PinotConfig setFetchRetryCount(int fetchRetryCount) {
        this.fetchRetryCount = fetchRetryCount;
        return this;
    }

    public int getNonAggregateLimitForBrokerQueries() {
        return this.nonAggregateLimitForBrokerQueries;
    }

    @Config(value="pinot.non-aggregate-limit-for-broker-queries")
    public PinotConfig setNonAggregateLimitForBrokerQueries(int nonAggregateLimitForBrokerQueries) {
        this.nonAggregateLimitForBrokerQueries = nonAggregateLimitForBrokerQueries;
        return this;
    }

    public boolean isInferDateTypeInSchema() {
        return this.inferDateTypeInSchema;
    }

    @Config(value="pinot.infer-date-type-in-schema")
    public PinotConfig setInferDateTypeInSchema(boolean inferDateTypeInSchema) {
        this.inferDateTypeInSchema = inferDateTypeInSchema;
        return this;
    }

    public boolean isInferTimestampTypeInSchema() {
        return this.inferTimestampTypeInSchema;
    }

    @Config(value="pinot.infer-timestamp-type-in-schema")
    public PinotConfig setInferTimestampTypeInSchema(boolean inferTimestampTypeInSchema) {
        this.inferTimestampTypeInSchema = inferTimestampTypeInSchema;
        return this;
    }

    public boolean isMarkDataFetchExceptionsAsRetriable() {
        return this.markDataFetchExceptionsAsRetriable;
    }

    @Config(value="pinot.mark-data-fetch-exceptions-as-retriable")
    public PinotConfig setMarkDataFetchExceptionsAsRetriable(boolean markDataFetchExceptionsAsRetriable) {
        this.markDataFetchExceptionsAsRetriable = markDataFetchExceptionsAsRetriable;
        return this;
    }

    public boolean isUsePinotSqlForBrokerQueries() {
        return this.usePinotSqlForBrokerQueries;
    }

    @Config(value="pinot.use-pinot-sql-for-broker-queries")
    public PinotConfig setUsePinotSqlForBrokerQueries(boolean usePinotSqlForBrokerQueries) {
        this.usePinotSqlForBrokerQueries = usePinotSqlForBrokerQueries;
        return this;
    }

    public boolean isPushdownTopNBrokerQueries() {
        return this.pushdownTopNBrokerQueries;
    }

    @Config(value="pinot.pushdown-topn-broker-queries")
    public PinotConfig setPushdownTopNBrokerQueries(boolean pushdownTopNBrokerQueries) {
        this.pushdownTopNBrokerQueries = pushdownTopNBrokerQueries;
        return this;
    }
}

