/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.ForPinot;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumn;
import com.facebook.presto.pinot.PinotColumnUtils;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotTable;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.pinot.common.data.Schema;

public class PinotConnection {
    private static final Object ALL_TABLES_CACHE_KEY = new Object();
    private final LoadingCache<String, List<PinotColumn>> pinotTableColumnCache;
    private final LoadingCache<Object, List<String>> allTablesCache;
    private final PinotConfig pinotConfig;
    private final PinotClusterInfoFetcher pinotClusterInfoFetcher;

    @Inject
    public PinotConnection(final PinotClusterInfoFetcher pinotClusterInfoFetcher, final PinotConfig pinotConfig, @ForPinot Executor executor) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinot config");
        long metadataCacheExpiryMillis = this.pinotConfig.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS);
        this.pinotClusterInfoFetcher = Objects.requireNonNull(pinotClusterInfoFetcher, "cluster info fetcher is null");
        this.allTablesCache = CacheBuilder.newBuilder().refreshAfterWrite(metadataCacheExpiryMillis, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(pinotClusterInfoFetcher::getAllTables), (Executor)executor));
        this.pinotTableColumnCache = CacheBuilder.newBuilder().refreshAfterWrite(metadataCacheExpiryMillis, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, List<PinotColumn>>(){

            public List<PinotColumn> load(String tableName) throws Exception {
                Schema tablePinotSchema = pinotClusterInfoFetcher.getTableSchema(tableName);
                return PinotColumnUtils.getPinotColumnsForPinotSchema(tablePinotSchema, pinotConfig.isInferDateTypeInSchema(), pinotConfig.isInferTimestampTypeInSchema());
            }
        }, (Executor)executor));
        executor.execute(() -> this.allTablesCache.refresh(ALL_TABLES_CACHE_KEY));
    }

    private static <K, V> V getFromCache(LoadingCache<K, V> cache, K key) {
        Object value = cache.getIfPresent(key);
        if (value != null) {
            return (V)value;
        }
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Cannot fetch from cache " + key, e.getCause());
        }
    }

    public List<String> getTableNames() {
        return PinotConnection.getFromCache(this.allTablesCache, ALL_TABLES_CACHE_KEY);
    }

    public PinotTable getTable(String tableName) {
        List<PinotColumn> columns = this.getPinotColumnsForTable(tableName);
        return new PinotTable(tableName, columns);
    }

    private List<PinotColumn> getPinotColumnsForTable(String tableName) {
        return PinotConnection.getFromCache(this.pinotTableColumnCache, tableName);
    }

    public Map<String, Map<String, List<String>>> getRoutingTable(String tableName) {
        return this.pinotClusterInfoFetcher.getRoutingTableForTable(tableName);
    }

    public PinotClusterInfoFetcher.TimeBoundary getTimeBoundary(String tableName) {
        return this.pinotClusterInfoFetcher.getTimeBoundaryForTable(tableName);
    }
}

