/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.presto.pinot.PinotMetricsStats;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class PinotMetrics {
    private final PinotMetricsStats getStats = new PinotMetricsStats(false);
    private final PinotMetricsStats queryStats = new PinotMetricsStats(true);
    private final PinotMetricsStats tablesStats = new PinotMetricsStats(true);
    private final PinotMetricsStats schemaStats = new PinotMetricsStats(true);
    private final PinotMetricsStats brokerTimeBoundaryStats = new PinotMetricsStats(false);
    private final PinotMetricsStats brokerRoutingTableStats = new PinotMetricsStats(true);

    @Managed
    @Nested
    public PinotMetricsStats getQueryStats() {
        return this.queryStats;
    }

    @Managed
    @Nested
    public PinotMetricsStats getGetStats() {
        return this.getStats;
    }

    @Managed
    @Nested
    public PinotMetricsStats getTablesStats() {
        return this.tablesStats;
    }

    @Managed
    @Nested
    public PinotMetricsStats getSchemaStats() {
        return this.schemaStats;
    }

    @Managed
    @Nested
    public PinotMetricsStats getBrokerTimeBoundaryStats() {
        return this.brokerTimeBoundaryStats;
    }

    @Managed
    @Nested
    public PinotMetricsStats getBrokerRoutingTableStats() {
        return this.brokerRoutingTableStats;
    }

    public void monitorRequest(Request request, StringResponseHandler.StringResponse response, long duration, TimeUnit timeUnit) {
        String[] split = request.getUri().getPath().split("/");
        String secondLast = split.length >= 2 ? split[split.length - 2].toLowerCase(Locale.ENGLISH) : null;
        String last = split[split.length - 1].toLowerCase(Locale.ENGLISH);
        if ("post".equalsIgnoreCase(request.getMethod()) && "query".equalsIgnoreCase(last)) {
            this.queryStats.record(response, duration, timeUnit);
        } else if ("get".equalsIgnoreCase(request.getMethod())) {
            block5 : switch (last) {
                case "tables": {
                    this.tablesStats.record(response, duration, timeUnit);
                    break;
                }
                case "schema": {
                    this.schemaStats.record(response, duration, timeUnit);
                    break;
                }
                case "debug": {
                    if (secondLast == null) break;
                    switch (secondLast) {
                        case "routingtable": {
                            this.brokerRoutingTableStats.record(response, duration, timeUnit);
                            break block5;
                        }
                        case "timeboundary": {
                            this.brokerTimeBoundaryStats.record(response, duration, timeUnit);
                        }
                    }
                }
            }
            this.getStats.record(response, duration, timeUnit);
        }
    }
}

