/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotScatterGatherQueryClient;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotSplit;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pinot.common.response.ServerInstance;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;

public class PinotSegmentPageSource
implements ConnectorPageSource {
    private static final Map<PinotScatterGatherQueryClient.ErrorCode, PinotErrorCode> PINOT_ERROR_CODE_MAP = ImmutableMap.of((Object)PinotScatterGatherQueryClient.ErrorCode.PINOT_UNCLASSIFIED_ERROR, (Object)((Object)PinotErrorCode.PINOT_UNCLASSIFIED_ERROR), (Object)PinotScatterGatherQueryClient.ErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, (Object)((Object)PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE), (Object)PinotScatterGatherQueryClient.ErrorCode.PINOT_INVALID_PQL_GENERATED, (Object)((Object)PinotErrorCode.PINOT_INVALID_PQL_GENERATED));
    private final List<PinotColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final PinotConfig pinotConfig;
    private final PinotSplit split;
    private final PinotScatterGatherQueryClient pinotQueryClient;
    private final ConnectorSession session;
    private LinkedList<PinotDataTableWithSize> dataTableList = new LinkedList();
    private long completedBytes;
    private long readTimeNanos;
    private long estimatedMemoryUsageInBytes;
    private PinotDataTableWithSize currentDataTable;
    private boolean closed;
    private boolean isPinotDataFetched;

    public PinotSegmentPageSource(ConnectorSession session, PinotConfig pinotConfig, PinotScatterGatherQueryClient pinotQueryClient, PinotSplit split, List<PinotColumnHandle> columnHandles) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinotConfig is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.pinotQueryClient = Objects.requireNonNull(pinotQueryClient, "pinotQueryClient is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.columnTypes = columnHandles.stream().map(PinotSegmentPageSource::getTypeForBlock).collect(Collectors.toList());
    }

    private static void checkExceptions(DataTable dataTable, PinotSplit split, boolean markDataFetchExceptionsAsRetriable) {
        Map metadata = dataTable.getMetadata();
        ArrayList exceptions = new ArrayList();
        metadata.forEach((k, v) -> {
            if (k.startsWith("Exception")) {
                exceptions.add(v);
            }
        });
        if (!exceptions.isEmpty()) {
            throw new PinotException(markDataFetchExceptionsAsRetriable ? PinotErrorCode.PINOT_DATA_FETCH_EXCEPTION : PinotErrorCode.PINOT_EXCEPTION, split.getSegmentPql(), String.format("Encountered %d pinot exceptions for split %s: %s", exceptions.size(), split, exceptions));
        }
        int numColumnsExpected = split.getExpectedColumnHandles().size();
        int numColumnsActual = dataTable.getDataSchema().size();
        if (numColumnsActual != numColumnsExpected) {
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, split.getSegmentPql(), String.format("Expected pinot to contain %d columns but got %d: %s", numColumnsExpected, numColumnsActual, dataTable.getDataSchema()));
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getSystemMemoryUsage() {
        return this.estimatedMemoryUsageInBytes;
    }

    public boolean isFinished() {
        return this.closed || this.isPinotDataFetched && this.dataTableList.isEmpty();
    }

    public Page getNextPage() {
        if (this.isFinished()) {
            this.close();
            return null;
        }
        if (!this.isPinotDataFetched) {
            this.fetchPinotData();
        }
        if (this.currentDataTable != null) {
            this.estimatedMemoryUsageInBytes -= (long)this.currentDataTable.getEstimatedSizeInBytes();
        }
        if (this.dataTableList.size() == 0) {
            this.close();
            return null;
        }
        this.currentDataTable = this.dataTableList.pop();
        List<PinotColumnHandle> expectedColumnHandles = this.split.getExpectedColumnHandles();
        PageBuilder pageBuilder = new PageBuilder(this.columnTypes);
        pageBuilder.declarePositions(this.currentDataTable.getDataTable().getNumberOfRows());
        for (int columnHandleIndex = 0; columnHandleIndex < this.columnHandles.size(); ++columnHandleIndex) {
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(columnHandleIndex);
            Type columnType = this.columnTypes.get(columnHandleIndex);
            PinotColumnHandle handle = this.columnHandles.get(columnHandleIndex);
            int indexReturnedByPinot = expectedColumnHandles.indexOf(handle);
            if (indexReturnedByPinot < 0) {
                throw new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, this.split.getSegmentPql(), String.format("Expected column handle %s to be present in the handles %s corresponding to the segment PQL", handle, expectedColumnHandles));
            }
            this.writeBlock(blockBuilder, columnType, indexReturnedByPinot);
        }
        return pageBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchPinotData() {
        long startTimeNanos = System.nanoTime();
        try {
            Map<ServerInstance, DataTable> dataTableMap = this.queryPinot(this.session, this.split);
            dataTableMap.values().stream().filter(table -> table != null && table.getNumberOfRows() > 0).forEach(dataTable -> {
                PinotSegmentPageSource.checkExceptions(dataTable, this.split, PinotSessionProperties.isMarkDataFetchExceptionsAsRetriable(this.session));
                int estimatedTableSizeInBytes = IntStream.rangeClosed(0, dataTable.getDataSchema().size() - 1).map(i -> this.getEstimatedColumnSizeInBytes(dataTable.getDataSchema().getColumnDataType(i)) * dataTable.getNumberOfRows()).reduce(0, Integer::sum);
                this.dataTableList.add(new PinotDataTableWithSize((DataTable)dataTable, estimatedTableSizeInBytes));
                this.estimatedMemoryUsageInBytes += (long)estimatedTableSizeInBytes;
            });
            this.isPinotDataFetched = true;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - startTimeNanos;
        }
    }

    private Map<ServerInstance, DataTable> queryPinot(ConnectorSession session, PinotSplit split) {
        String pql = split.getSegmentPql().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the pql"));
        String host = split.getSegmentHost().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the host"));
        try {
            return ImmutableMap.copyOf((Map)this.pinotQueryClient.queryPinotServerForDataTable(pql, host, split.getSegments(), PinotSessionProperties.getConnectionTimeout(session).toMillis(), PinotSessionProperties.isIgnoreEmptyResponses(session), PinotSessionProperties.getPinotRetryCount(session)));
        }
        catch (PinotScatterGatherQueryClient.PinotException pe) {
            throw new PinotException(PINOT_ERROR_CODE_MAP.getOrDefault(pe.getErrorCode(), PinotErrorCode.PINOT_UNCLASSIFIED_ERROR), Optional.of(pql), String.format("Error when hitting host %s", host), pe);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private void writeBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        Class javaType = columnType.getJavaType();
        DataSchema.ColumnDataType pinotColumnType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        if (columnType instanceof ArrayType) {
            this.writeArrayBlock(blockBuilder, columnType, columnIndex);
        } else if (javaType.equals(Boolean.TYPE)) {
            this.writeBooleanBlock(blockBuilder, columnType, columnIndex);
        } else if (javaType.equals(Long.TYPE)) {
            this.writeLongBlock(blockBuilder, columnType, columnIndex);
        } else if (javaType.equals(Double.TYPE)) {
            this.writeDoubleBlock(blockBuilder, columnType, columnIndex);
        } else if (javaType.equals(Slice.class)) {
            this.writeSliceBlock(blockBuilder, columnType, columnIndex);
        } else {
            throw new PrestoException((ErrorCodeSupplier)PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, String.format("Failed to write column %s. pinotColumnType %s, javaType %s", this.split.getExpectedColumnHandles().get(columnIndex).getColumnName(), pinotColumnType, javaType));
        }
    }

    private void writeArrayBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int rowIndex = 0; rowIndex < this.currentDataTable.getDataTable().getNumberOfRows(); ++rowIndex) {
            DataSchema.ColumnDataType columnPinotType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
            Type columnPrestoType = ((ArrayType)columnType).getElementType();
            BlockBuilder childBuilder = blockBuilder.beginBlockEntry();
            switch (columnPinotType) {
                case INT_ARRAY: {
                    int[] intArray = this.currentDataTable.getDataTable().getIntArray(rowIndex, columnIndex);
                    for (int i = 0; i < intArray.length; ++i) {
                        columnPrestoType.writeLong(childBuilder, (long)intArray[i]);
                        this.completedBytes += 8L;
                    }
                    break;
                }
                case LONG_ARRAY: {
                    long[] longArray = this.currentDataTable.getDataTable().getLongArray(rowIndex, columnIndex);
                    for (int i = 0; i < longArray.length; ++i) {
                        columnPrestoType.writeLong(childBuilder, longArray[i]);
                        this.completedBytes += 8L;
                    }
                    break;
                }
                case FLOAT_ARRAY: {
                    float[] floatArray = this.currentDataTable.getDataTable().getFloatArray(rowIndex, columnIndex);
                    if (columnPrestoType.getJavaType().equals(Long.TYPE)) {
                        for (int i = 0; i < floatArray.length; ++i) {
                            columnPrestoType.writeLong(childBuilder, (long)floatArray[i]);
                            this.completedBytes += 8L;
                        }
                    } else {
                        for (int i = 0; i < floatArray.length; ++i) {
                            columnPrestoType.writeDouble(childBuilder, (double)floatArray[i]);
                            this.completedBytes += 8L;
                        }
                    }
                    break;
                }
                case DOUBLE_ARRAY: {
                    double[] doubleArray = this.currentDataTable.getDataTable().getDoubleArray(rowIndex, columnIndex);
                    if (columnPrestoType.getJavaType().equals(Long.TYPE)) {
                        for (int i = 0; i < doubleArray.length; ++i) {
                            columnPrestoType.writeLong(childBuilder, (long)doubleArray[i]);
                            this.completedBytes += 8L;
                        }
                    } else {
                        for (int i = 0; i < doubleArray.length; ++i) {
                            columnPrestoType.writeDouble(childBuilder, doubleArray[i]);
                            this.completedBytes += 8L;
                        }
                    }
                    break;
                }
                case STRING_ARRAY: {
                    String[] stringArray = this.currentDataTable.getDataTable().getStringArray(rowIndex, columnIndex);
                    for (int i = 0; i < stringArray.length; ++i) {
                        Slice slice = Slices.utf8Slice((String)stringArray[i]);
                        childBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
                        this.completedBytes += (long)slice.getBytes().length;
                    }
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, String.format("Failed to write column %s. pinotColumnType %s, prestoType %s", this.split.getExpectedColumnHandles().get(columnIndex).getColumnName(), columnPinotType, columnPrestoType));
                }
            }
            blockBuilder.closeEntry();
        }
    }

    private void writeBooleanBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            columnType.writeBoolean(blockBuilder, this.getBoolean(i, columnIndex));
            ++this.completedBytes;
        }
    }

    private void writeLongBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            columnType.writeLong(blockBuilder, this.getLong(i, columnIndex));
            this.completedBytes += 8L;
        }
    }

    private void writeDoubleBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            columnType.writeDouble(blockBuilder, this.getDouble(i, columnIndex));
            this.completedBytes += 8L;
        }
    }

    private void writeSliceBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            Slice slice = this.getSlice(i, columnIndex);
            columnType.writeSlice(blockBuilder, slice, 0, slice.length());
            this.completedBytes += (long)slice.getBytes().length;
        }
    }

    private boolean getBoolean(int rowIndex, int columnIndex) {
        return Boolean.getBoolean(this.currentDataTable.getDataTable().getString(rowIndex, columnIndex));
    }

    private long getLong(int rowIndex, int columnIndex) {
        DataSchema.ColumnDataType dataType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        if (dataType.equals((Object)DataSchema.ColumnDataType.DOUBLE)) {
            return (long)this.currentDataTable.getDataTable().getDouble(rowIndex, columnIndex);
        }
        if (dataType.equals((Object)DataSchema.ColumnDataType.INT)) {
            return this.currentDataTable.getDataTable().getInt(rowIndex, columnIndex);
        }
        return this.currentDataTable.getDataTable().getLong(rowIndex, columnIndex);
    }

    private double getDouble(int rowIndex, int columnIndex) {
        DataSchema.ColumnDataType dataType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        if (dataType.equals((Object)DataSchema.ColumnDataType.FLOAT)) {
            return this.currentDataTable.getDataTable().getFloat(rowIndex, columnIndex);
        }
        return this.currentDataTable.getDataTable().getDouble(rowIndex, columnIndex);
    }

    private Slice getSlice(int rowIndex, int columnIndex) {
        this.checkColumnType(columnIndex, (Type)VarcharType.VARCHAR);
        DataSchema.ColumnDataType columnType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        switch (columnType) {
            case INT_ARRAY: {
                int[] intArray = this.currentDataTable.getDataTable().getIntArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(intArray));
            }
            case LONG_ARRAY: {
                long[] longArray = this.currentDataTable.getDataTable().getLongArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(longArray));
            }
            case FLOAT_ARRAY: {
                float[] floatArray = this.currentDataTable.getDataTable().getFloatArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(floatArray));
            }
            case DOUBLE_ARRAY: {
                double[] doubleArray = this.currentDataTable.getDataTable().getDoubleArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(doubleArray));
            }
            case STRING_ARRAY: {
                Object[] stringArray = this.currentDataTable.getDataTable().getStringArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(stringArray));
            }
            case STRING: {
                String field = this.currentDataTable.getDataTable().getString(rowIndex, columnIndex);
                if (field == null || field.isEmpty()) {
                    return Slices.EMPTY_SLICE;
                }
                return Slices.utf8Slice((String)field);
            }
        }
        return Slices.EMPTY_SLICE;
    }

    private int getEstimatedColumnSizeInBytes(DataSchema.ColumnDataType dataType) {
        if (dataType.isNumber()) {
            switch (dataType) {
                case LONG: {
                    return 8;
                }
                case FLOAT: {
                    return 4;
                }
                case DOUBLE: {
                    return 8;
                }
            }
            return 4;
        }
        return this.pinotConfig.getEstimatedSizeInBytesForNonNumericColumn();
    }

    private void checkColumnType(int columnIndex, Type expected) {
        Preconditions.checkArgument((columnIndex < this.split.getExpectedColumnHandles().size() ? 1 : 0) != 0, (Object)"Invalid field index");
        Type actual = this.split.getExpectedColumnHandles().get(columnIndex).getDataType();
        Preconditions.checkArgument((boolean)actual.equals(expected), (String)"Expected column %s to be type %s but is %s", (Object)columnIndex, (Object)expected, (Object)actual);
    }

    private static Type getTypeForBlock(PinotColumnHandle pinotColumnHandle) {
        if (pinotColumnHandle.getDataType().equals(IntegerType.INTEGER)) {
            return BigintType.BIGINT;
        }
        return pinotColumnHandle.getDataType();
    }

    public long getCompletedPositions() {
        return 0L;
    }

    private static class PinotDataTableWithSize {
        DataTable dataTable;
        int estimatedSizeInBytes;

        PinotDataTableWithSize(DataTable dataTable, int estimatedSizeInBytes) {
            this.dataTable = dataTable;
            this.estimatedSizeInBytes = estimatedSizeInBytes;
        }

        DataTable getDataTable() {
            return this.dataTable;
        }

        int getEstimatedSizeInBytes() {
            return this.estimatedSizeInBytes;
        }
    }
}

