/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PinotSplit
implements ConnectorSplit {
    private final String connectorId;
    private final SplitType splitType;
    private final List<PinotColumnHandle> expectedColumnHandles;
    private final Optional<PinotQueryGenerator.GeneratedPinotQuery> brokerPinotQuery;
    private final Optional<String> segmentPql;
    private final List<String> segments;
    private final Optional<String> segmentHost;

    @JsonCreator
    public PinotSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="splitType") SplitType splitType, @JsonProperty(value="expectedColumnHandles") List<PinotColumnHandle> expectedColumnHandles, @JsonProperty(value="brokerQuery") Optional<PinotQueryGenerator.GeneratedPinotQuery> brokerPinotQuery, @JsonProperty(value="segmentPql") Optional<String> segmentPql, @JsonProperty(value="segments") List<String> segments, @JsonProperty(value="segmentHost") Optional<String> segmentHost) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.splitType = Objects.requireNonNull(splitType, "splitType id is null");
        this.expectedColumnHandles = Objects.requireNonNull(expectedColumnHandles, "expected column handles is null");
        this.brokerPinotQuery = Objects.requireNonNull(brokerPinotQuery, "brokerPinotQuery is null");
        this.segmentPql = Objects.requireNonNull(segmentPql, "table name is null");
        this.segments = ImmutableList.copyOf((Collection)Objects.requireNonNull(segments, "segment is null"));
        this.segmentHost = Objects.requireNonNull(segmentHost, "host is null");
        if (splitType == SplitType.SEGMENT) {
            Preconditions.checkArgument((boolean)segmentPql.isPresent(), (Object)"Table name is missing from the split");
            Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Segments are missing from the split");
            Preconditions.checkArgument((boolean)segmentHost.isPresent(), (Object)"Segment host address is missing from the split");
        } else {
            Preconditions.checkArgument((boolean)brokerPinotQuery.isPresent(), (Object)"brokerPinotQuery is missing from the split");
        }
    }

    public static PinotSplit createBrokerSplit(String connectorId, List<PinotColumnHandle> expectedColumnHandles, PinotQueryGenerator.GeneratedPinotQuery brokerQuery) {
        return new PinotSplit(Objects.requireNonNull(connectorId, "connector id is null"), SplitType.BROKER, expectedColumnHandles, Optional.of(Objects.requireNonNull(brokerQuery, "brokerQuery is null")), Optional.empty(), (List<String>)ImmutableList.of(), Optional.empty());
    }

    public static PinotSplit createSegmentSplit(String connectorId, String pql, List<PinotColumnHandle> expectedColumnHandles, List<String> segments, String segmentHost) {
        return new PinotSplit(Objects.requireNonNull(connectorId, "connector id is null"), SplitType.SEGMENT, expectedColumnHandles, Optional.empty(), Optional.of(Objects.requireNonNull(pql, "pql is null")), Objects.requireNonNull(segments, "segments are null"), Optional.of(Objects.requireNonNull(segmentHost, "segmentHost is null")));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public SplitType getSplitType() {
        return this.splitType;
    }

    @JsonProperty
    public Optional<PinotQueryGenerator.GeneratedPinotQuery> getBrokerPinotQuery() {
        return this.brokerPinotQuery;
    }

    @JsonProperty
    public Optional<String> getSegmentPql() {
        return this.segmentPql;
    }

    @JsonProperty
    public Optional<String> getSegmentHost() {
        return this.segmentHost;
    }

    @JsonProperty
    public List<String> getSegments() {
        return this.segments;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("splitType", (Object)this.splitType).add("columnHandle", this.expectedColumnHandles).add("segmentPql", this.segmentPql).add("brokerPinotQuery", this.brokerPinotQuery).add("segments", this.segments).add("segmentHost", this.segmentHost).toString();
    }

    @JsonProperty
    public List<PinotColumnHandle> getExpectedColumnHandles() {
        return this.expectedColumnHandles;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public static enum SplitType {
        SEGMENT,
        BROKER;

    }
}

