/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.query.PinotExpression;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class PinotProjectExpressionConverter
implements RowExpressionVisitor<PinotExpression, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>> {
    private static final Set<String> TIME_EQUIVALENT_TYPES = ImmutableSet.of((Object)"bigint", (Object)"integer", (Object)"tinyint", (Object)"smallint");
    protected final TypeManager typeManager;
    protected final StandardFunctionResolution standardFunctionResolution;

    public PinotProjectExpressionConverter(TypeManager typeManager, StandardFunctionResolution standardFunctionResolution) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
    }

    public PinotExpression visitVariableReference(VariableReferenceExpression reference, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        PinotQueryGeneratorContext.Selection input = Objects.requireNonNull(context.get(reference), String.format("Input column %s does not exist in the input", reference));
        return new PinotExpression(input.getDefinition(), input.getOrigin());
    }

    public PinotExpression visitLambda(LambdaDefinitionExpression lambda, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support lambda " + lambda);
    }

    protected boolean isImplicitCast(Type inputType, Type resultType) {
        if (this.typeManager.canCoerce(inputType, resultType)) {
            return true;
        }
        return resultType.getTypeSignature().getBase().equals("timestamp") && TIME_EQUIVALENT_TYPES.contains(inputType.getTypeSignature().getBase());
    }

    private PinotExpression handleCast(CallExpression cast, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (cast.getArguments().size() == 1) {
            RowExpression input = (RowExpression)cast.getArguments().get(0);
            Type expectedType = cast.getType();
            if (this.isImplicitCast(input.getType(), expectedType)) {
                return (PinotExpression)input.accept((RowExpressionVisitor)this, context);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Non implicit casts not supported: " + cast);
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("This type of CAST operator not supported. Received: %s", cast));
    }

    protected Optional<PinotExpression> basicCallHandling(CallExpression call, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (this.standardFunctionResolution.isNotFunction(functionHandle) || this.standardFunctionResolution.isBetweenFunction(functionHandle)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unsupported function in pinot aggregation: " + functionHandle);
        }
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            return Optional.of(this.handleCast(call, context));
        }
        return Optional.empty();
    }

    public PinotExpression visitInputReference(InputReferenceExpression reference, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Input reference not supported: " + reference);
    }

    public PinotExpression visitSpecialForm(SpecialFormExpression specialForm, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Special form not supported: " + specialForm);
    }

    public PinotExpression visitCall(CallExpression call, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return this.basicCallHandling(call, context).orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Call not supported: " + call));
    }

    public PinotExpression visitConstant(ConstantExpression literal, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Constant not supported: " + literal);
    }
}

