/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Function;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pinot.$internal.io.netty.util.HashedWheelTimer;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.CompositeFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyClientMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.PooledNettyClientResourceManager;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.KeyedPoolImpl;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGather;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGatherImpl;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGatherRequest;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGatherStats;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.response.ServerInstance;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.serde.SerDe;

public class PinotScatterGatherQueryClient {
    private static final Pql2Compiler REQUEST_COMPILER = new Pql2Compiler();
    private static final String PRESTO_HOST_PREFIX = "presto-pinot-master";
    private static final boolean DEFAULT_EMIT_TABLE_LEVEL_METRICS = true;
    private final String prestoHostId = this.getDefaultPrestoId();
    private final BrokerMetrics brokerMetrics;
    private final ScatterGather scatterGatherer;

    public PinotScatterGatherQueryClient(Config pinotConfig) {
        MetricsRegistry registry = new MetricsRegistry();
        this.brokerMetrics = new BrokerMetrics(registry, true);
        this.brokerMetrics.initializeGlobalMeters();
        NettyClientMetrics clientMetrics = new NettyClientMetrics(registry, "presto_pinot_client_");
        PooledNettyClientResourceManager resourceManager = new PooledNettyClientResourceManager(new NioEventLoopGroup(), new HashedWheelTimer(), clientMetrics);
        ExecutorService requestSenderPool = Executors.newFixedThreadPool(pinotConfig.getThreadPoolSize());
        ScheduledThreadPoolExecutor poolTimeoutExecutor = new ScheduledThreadPoolExecutor(50);
        KeyedPoolImpl<PooledNettyClientResourceManager.PooledClientConnection> connPool = new KeyedPoolImpl<PooledNettyClientResourceManager.PooledClientConnection>(pinotConfig.getMinConnectionsPerServer(), pinotConfig.getMaxConnectionsPerServer(), pinotConfig.getIdleTimeoutMillis(), pinotConfig.getMaxBacklogPerServer(), resourceManager, poolTimeoutExecutor, requestSenderPool, registry);
        resourceManager.setPool(connPool);
        this.scatterGatherer = new ScatterGatherImpl(connPool, requestSenderPool);
    }

    private static <T> T doWithRetries(int retries, Function<Integer, T> caller) {
        PinotException firstError = null;
        for (int i = 0; i < retries; ++i) {
            try {
                return caller.apply(i);
            }
            catch (PinotException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (e.getErrorCode().isRetriable()) continue;
                throw e;
            }
        }
        throw firstError;
    }

    private String getDefaultPrestoId() {
        String defaultBrokerId;
        try {
            defaultBrokerId = PRESTO_HOST_PREFIX + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            defaultBrokerId = PRESTO_HOST_PREFIX;
        }
        return defaultBrokerId;
    }

    public Map<ServerInstance, DataTable> queryPinotServerForDataTable(String pql, String serverHost, List<String> segments, long connectionTimeoutInMillis, boolean ignoreEmptyResponses, int pinotRetryCount) {
        BrokerRequest brokerRequest;
        try {
            brokerRequest = REQUEST_COMPILER.compileToBrokerRequest(pql);
        }
        catch (Pql2CompilationException e) {
            throw new PinotException(ErrorCode.PINOT_INVALID_PQL_GENERATED, String.format("Parsing error with on %s, Error = %s", serverHost, e.getMessage()), e);
        }
        HashMap<String, ArrayList<String>> routingTable = new HashMap<String, ArrayList<String>>();
        routingTable.put(serverHost, new ArrayList<String>(segments));
        Map serverResponseMap = PinotScatterGatherQueryClient.doWithRetries(pinotRetryCount, requestId -> {
            ScatterGatherRequestWrapper scatterRequest = new ScatterGatherRequestWrapper(brokerRequest, routingTable, requestId.intValue(), connectionTimeoutInMillis, this.prestoHostId);
            ScatterGatherStats scatterGatherStats = new ScatterGatherStats();
            CompositeFuture<byte[]> compositeFuture = this.routeScatterGather(scatterRequest, scatterGatherStats);
            return this.gatherServerResponses(ignoreEmptyResponses, routingTable, compositeFuture, brokerRequest.getQuerySource().getTableName());
        });
        return this.deserializeServerResponses(serverResponseMap, brokerRequest.getQuerySource().getTableName());
    }

    private Map<ServerInstance, byte[]> gatherServerResponses(boolean ignoreEmptyResponses, Map<String, List<String>> routingTable, CompositeFuture<byte[]> compositeFuture, String tableNameWithType) {
        try {
            Object serverResponseMap = compositeFuture.get();
            if (!ignoreEmptyResponses) {
                if (serverResponseMap.size() != routingTable.size()) {
                    HashMap routingTableForLogging = new HashMap();
                    routingTable.entrySet().forEach(entry -> {
                        String valueToPrint = ((List)entry.getValue()).size() > 10 ? String.format("%d segments", ((List)entry.getValue()).size()) : ((List)entry.getValue()).toString();
                        routingTableForLogging.put(entry.getKey(), valueToPrint);
                    });
                    throw new PinotException(ErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, String.format("%d of %d servers responded with routing table servers: %s, error: %s", serverResponseMap.size(), routingTable.size(), routingTableForLogging, compositeFuture.getError()));
                }
                for (Map.Entry entry2 : serverResponseMap.entrySet()) {
                    if (((byte[])entry2.getValue()).length != 0) continue;
                    throw new PinotException(ErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, String.format("Got empty response with from server: %s", ((ServerInstance)entry2.getKey()).getShortHostName()));
                }
            }
            return serverResponseMap;
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable err = e instanceof ExecutionException ? e.getCause() : e;
            throw new PinotException(ErrorCode.PINOT_UNCLASSIFIED_ERROR, String.format("Caught exception while fetching responses for table: %s", tableNameWithType), err);
        }
    }

    private Map<ServerInstance, DataTable> deserializeServerResponses(Map<ServerInstance, byte[]> responseMap, String tableNameWithType) {
        HashMap<ServerInstance, DataTable> dataTableMap = new HashMap<ServerInstance, DataTable>();
        for (Map.Entry<ServerInstance, byte[]> entry : responseMap.entrySet()) {
            ServerInstance serverInstance = entry.getKey();
            byte[] value = entry.getValue();
            if (value == null || value.length == 0) continue;
            try {
                dataTableMap.put(serverInstance, DataTableFactory.getDataTable(value));
            }
            catch (IOException e) {
                throw new PinotException(ErrorCode.PINOT_UNCLASSIFIED_ERROR, String.format("Caught exceptions while deserializing response for table: %s from server: %s", tableNameWithType, serverInstance), e);
            }
        }
        return dataTableMap;
    }

    private CompositeFuture<byte[]> routeScatterGather(ScatterGatherRequest scatterRequest, ScatterGatherStats scatterGatherStats) {
        try {
            return this.scatterGatherer.scatterGather(scatterRequest, scatterGatherStats, true, this.brokerMetrics);
        }
        catch (InterruptedException e) {
            throw new PinotException(ErrorCode.PINOT_UNCLASSIFIED_ERROR, String.format("Interrupted while sending request: %s", scatterRequest), e);
        }
    }

    private static class ScatterGatherRequestWrapper
    implements ScatterGatherRequest {
        private final BrokerRequest brokerRequest;
        private final Map<String, List<String>> routingTable;
        private final long requestId;
        private final long requestTimeoutMs;
        private final String brokerId;

        public ScatterGatherRequestWrapper(BrokerRequest request, Map<String, List<String>> routingTable, long requestId, long requestTimeoutMs, String brokerId) {
            this.brokerRequest = request;
            this.routingTable = routingTable;
            this.requestId = requestId;
            this.requestTimeoutMs = requestTimeoutMs;
            this.brokerId = brokerId;
        }

        @Override
        public Map<String, List<String>> getRoutingTable() {
            return this.routingTable;
        }

        @Override
        public byte[] getRequestForService(List<String> segments) {
            InstanceRequest request = new InstanceRequest();
            request.setRequestId(this.requestId);
            request.setEnableTrace(this.brokerRequest.isEnableTrace());
            request.setQuery(this.brokerRequest);
            request.setSearchSegments(segments);
            request.setBrokerId(this.brokerId);
            return new SerDe(new .TCompactProtocol.Factory()).serialize(request);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @Override
        public long getRequestTimeoutMs() {
            return this.requestTimeoutMs;
        }

        @Override
        public BrokerRequest getBrokerRequest() {
            return this.brokerRequest;
        }

        public String toString() {
            if (this.routingTable == null) {
                return null;
            }
            return Arrays.toString(this.routingTable.entrySet().toArray());
        }
    }

    public static class Config {
        private final long idleTimeoutMillis;
        private final int threadPoolSize;
        private final int minConnectionsPerServer;
        private final int maxBacklogPerServer;
        private final int maxConnectionsPerServer;

        public Config(long idleTimeoutMillis, int threadPoolSize, int minConnectionsPerServer, int maxBacklogPerServer, int maxConnectionsPerServer) {
            this.idleTimeoutMillis = idleTimeoutMillis;
            this.threadPoolSize = threadPoolSize;
            this.minConnectionsPerServer = minConnectionsPerServer;
            this.maxBacklogPerServer = maxBacklogPerServer;
            this.maxConnectionsPerServer = maxConnectionsPerServer;
        }

        public long getIdleTimeoutMillis() {
            return this.idleTimeoutMillis;
        }

        public int getThreadPoolSize() {
            return this.threadPoolSize;
        }

        public int getMinConnectionsPerServer() {
            return this.minConnectionsPerServer;
        }

        public int getMaxBacklogPerServer() {
            return this.maxBacklogPerServer;
        }

        public int getMaxConnectionsPerServer() {
            return this.maxConnectionsPerServer;
        }
    }

    public static class PinotException
    extends RuntimeException {
        private final ErrorCode errorCode;

        public PinotException(ErrorCode errorCode, String message, Throwable t) {
            super(message, t);
            this.errorCode = errorCode;
        }

        public PinotException(ErrorCode errorCode, String message) {
            this(errorCode, message, null);
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }
    }

    public static enum ErrorCode {
        PINOT_INSUFFICIENT_SERVER_RESPONSE(true),
        PINOT_INVALID_PQL_GENERATED(false),
        PINOT_UNCLASSIFIED_ERROR(false);

        private final boolean retriable;

        private ErrorCode(boolean retriable) {
            this.retriable = retriable;
        }

        public boolean isRetriable() {
            return this.retriable;
        }
    }
}

