/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.commons.beanutils.PropertyUtils;
import org.apache.pinot.$internal.org.apache.commons.collections.Predicate;

public class BeanPropertyValueEqualsPredicate
implements Predicate {
    private final .Log log = .LogFactory.getLog(this.getClass());
    private String propertyName;
    private Object propertyValue;
    private boolean ignoreNull;

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.ignoreNull = ignoreNull;
    }

    public boolean evaluate(Object object) {
        boolean evaluation = false;
        try {
            evaluation = this.evaluateValue(this.propertyValue, PropertyUtils.getProperty(object, this.propertyName));
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during evaluation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn((Object)"WARNING: Problem during evaluation. Null value encountered in property path...", (Throwable)e);
            }
            this.log.error((Object)"ERROR: Problem during evaluation. Null value encountered in property path...", (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            this.log.error((Object)"Unable to access the property provided.", (Throwable)e);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            this.log.error((Object)"Exception occurred in property's getter", (Throwable)e);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "Property not found.";
            this.log.error((Object)"Property not found.", (Throwable)e);
            throw new IllegalArgumentException("Property not found.");
        }
        return evaluation;
    }

    private boolean evaluateValue(Object expected, Object actual) {
        return expected == actual || expected != null && expected.equals(actual);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

