/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.$internal.org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.pinot.$internal.org.apache.commons.configuration.tree.ConfigurationNode;

public class SubnodeConfiguration
extends HierarchicalConfiguration {
    private static final long serialVersionUID = 3105734147019386480L;
    private HierarchicalConfiguration parent;
    private String subnodeKey;

    public SubnodeConfiguration(HierarchicalConfiguration parent, ConfigurationNode root) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent configuration must not be null!");
        }
        if (root == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.setRootNode(root);
        this.parent = parent;
        this.initFromParent(parent);
    }

    public HierarchicalConfiguration getParent() {
        return this.parent;
    }

    public String getSubnodeKey() {
        return this.subnodeKey;
    }

    public void setSubnodeKey(String subnodeKey) {
        this.subnodeKey = subnodeKey;
    }

    public ConfigurationNode getRootNode() {
        if (this.getSubnodeKey() != null) {
            try {
                List nodes = this.getParent().fetchNodeList(this.getSubnodeKey());
                if (nodes.size() == 1) {
                    ConfigurationNode currentRoot = (ConfigurationNode)nodes.get(0);
                    if (currentRoot != super.getRootNode()) {
                        this.setRootNode(currentRoot);
                    }
                    return currentRoot;
                }
                this.setSubnodeKey(null);
            }
            catch (Exception ex) {
                this.setSubnodeKey(null);
            }
        }
        return super.getRootNode();
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node) {
        SubnodeConfiguration result = new SubnodeConfiguration(this.getParent(), node);
        this.getParent().registerSubnodeConfiguration(result);
        return result;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node, String subnodeKey) {
        SubnodeConfiguration result = this.createSubnodeConfiguration(node);
        if (this.getSubnodeKey() != null) {
            ArrayList<ConfigurationNode> lstPathToRoot = new ArrayList<ConfigurationNode>();
            ConfigurationNode top = super.getRootNode();
            for (ConfigurationNode nd = node; nd != top; nd = nd.getParentNode()) {
                lstPathToRoot.add(nd);
            }
            Collections.reverse(lstPathToRoot);
            String key = this.getSubnodeKey();
            Iterator it = lstPathToRoot.iterator();
            while (it.hasNext()) {
                key = this.getParent().getExpressionEngine().nodeKey((ConfigurationNode)it.next(), key);
            }
            result.setSubnodeKey(key);
        }
        return result;
    }

    protected HierarchicalConfiguration.Node createNode(String name) {
        return this.getParent().createNode(name);
    }

    protected void initFromParent(HierarchicalConfiguration parentConfig) {
        this.setExpressionEngine(parentConfig.getExpressionEngine());
        this.setListDelimiter(parentConfig.getListDelimiter());
        this.setDelimiterParsingDisabled(parentConfig.isDelimiterParsingDisabled());
        this.setThrowExceptionOnMissing(parentConfig.isThrowExceptionOnMissing());
    }

    protected Object interpolate(Object value) {
        return this.getParent().interpolate(value);
    }
}

