/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.pinot.$internal.org.apache.commons.math.MathException;
import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.pinot.$internal.org.apache.commons.math.distribution.FDistribution;
import org.apache.pinot.$internal.org.apache.commons.math.special.Beta;

public class FDistributionImpl
extends AbstractContinuousDistribution
implements FDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final String NON_POSITIVE_DEGREES_OF_FREEDOM_MESSAGE = "degrees of freedom must be positive ({0})";
    private static final long serialVersionUID = -8516354193418641566L;
    private double numeratorDegreesOfFreedom;
    private double denominatorDegreesOfFreedom;
    private final double solverAbsoluteAccuracy;

    public FDistributionImpl(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        this(numeratorDegreesOfFreedom, denominatorDegreesOfFreedom, 1.0E-9);
    }

    public FDistributionImpl(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom, double inverseCumAccuracy) {
        this.setNumeratorDegreesOfFreedomInternal(numeratorDegreesOfFreedom);
        this.setDenominatorDegreesOfFreedomInternal(denominatorDegreesOfFreedom);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double density(double x) {
        double nhalf = this.numeratorDegreesOfFreedom / 2.0;
        double mhalf = this.denominatorDegreesOfFreedom / 2.0;
        double logx = Math.log(x);
        double logn = Math.log(this.numeratorDegreesOfFreedom);
        double logm = Math.log(this.denominatorDegreesOfFreedom);
        double lognxm = Math.log(this.numeratorDegreesOfFreedom * x + this.denominatorDegreesOfFreedom);
        return Math.exp(nhalf * logn + nhalf * logx - logx + mhalf * logm - nhalf * lognxm - mhalf * lognxm - Beta.logBeta(nhalf, mhalf));
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret;
        if (x <= 0.0) {
            ret = 0.0;
        } else {
            double n = this.numeratorDegreesOfFreedom;
            double m = this.denominatorDegreesOfFreedom;
            ret = Beta.regularizedBeta(n * x / (m + n * x), 0.5 * n, 0.5 * m);
        }
        return ret;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p) {
        double ret = 1.0;
        double d = this.denominatorDegreesOfFreedom;
        if (d > 2.0) {
            ret = d / (d - 2.0);
        }
        return ret;
    }

    @Deprecated
    public void setNumeratorDegreesOfFreedom(double degreesOfFreedom) {
        this.setNumeratorDegreesOfFreedomInternal(degreesOfFreedom);
    }

    private void setNumeratorDegreesOfFreedomInternal(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(NON_POSITIVE_DEGREES_OF_FREEDOM_MESSAGE, degreesOfFreedom);
        }
        this.numeratorDegreesOfFreedom = degreesOfFreedom;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    @Deprecated
    public void setDenominatorDegreesOfFreedom(double degreesOfFreedom) {
        this.setDenominatorDegreesOfFreedomInternal(degreesOfFreedom);
    }

    private void setDenominatorDegreesOfFreedomInternal(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(NON_POSITIVE_DEGREES_OF_FREEDOM_MESSAGE, degreesOfFreedom);
        }
        this.denominatorDegreesOfFreedom = degreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

