/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.pinot.$internal.org.apache.commons.math.MathException;
import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.MaxIterationsExceededException;
import org.apache.pinot.$internal.org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.pinot.$internal.org.apache.commons.math.distribution.NormalDistribution;
import org.apache.pinot.$internal.org.apache.commons.math.special.Erf;

public class NormalDistributionImpl
extends AbstractContinuousDistribution
implements NormalDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private double mean = 0.0;
    private double standardDeviation = 1.0;
    private final double solverAbsoluteAccuracy;

    public NormalDistributionImpl(double mean, double sd) {
        this(mean, sd, 1.0E-9);
    }

    public NormalDistributionImpl(double mean, double sd, double inverseCumAccuracy) {
        this.setMeanInternal(mean);
        this.setStandardDeviationInternal(sd);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public NormalDistributionImpl() {
        this(0.0, 1.0);
    }

    public double getMean() {
        return this.mean;
    }

    @Deprecated
    public void setMean(double mean) {
        this.setMeanInternal(mean);
    }

    private void setMeanInternal(double newMean) {
        this.mean = newMean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Deprecated
    public void setStandardDeviation(double sd) {
        this.setStandardDeviationInternal(sd);
    }

    private void setStandardDeviationInternal(double sd) {
        if (sd <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("standard deviation must be positive ({0})", sd);
        }
        this.standardDeviation = sd;
    }

    public double density(Double x) {
        return this.density((double)x);
    }

    public double density(double x) {
        double x0 = x - this.mean;
        return Math.exp(-x0 * x0 / (2.0 * this.standardDeviation * this.standardDeviation)) / (this.standardDeviation * SQRT2PI);
    }

    public double cumulativeProbability(double x) throws MathException {
        try {
            return 0.5 * (1.0 + Erf.erf((x - this.mean) / (this.standardDeviation * Math.sqrt(2.0))));
        }
        catch (MaxIterationsExceededException ex) {
            if (x < this.mean - 20.0 * this.standardDeviation) {
                return 0.0;
            }
            if (x > this.mean + 20.0 * this.standardDeviation) {
                return 1.0;
            }
            throw ex;
        }
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    protected double getDomainLowerBound(double p) {
        double ret = p < 0.5 ? -1.7976931348623157E308 : this.mean;
        return ret;
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.mean : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.mean - this.standardDeviation : (p > 0.5 ? this.mean + this.standardDeviation : this.mean);
        return ret;
    }
}

