/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.genetics;

import org.apache.pinot.$internal.org.apache.commons.math.genetics.Population;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.StoppingCondition;

public class FixedGenerationCount
implements StoppingCondition {
    private int numGenerations = 0;
    private final int maxGenerations;

    public FixedGenerationCount(int maxGenerations) {
        if (maxGenerations <= 0) {
            throw new IllegalArgumentException("The number of generations has to be >= 0");
        }
        this.maxGenerations = maxGenerations;
    }

    public boolean isSatisfied(Population population) {
        if (this.numGenerations < this.maxGenerations) {
            ++this.numGenerations;
            return false;
        }
        return true;
    }

    public int getNumGenerations() {
        return this.numGenerations;
    }
}

