/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.Chromosome;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.Population;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPopulation
implements Population {
    private List<Chromosome> chromosomes;
    private int populationLimit;

    public ListPopulation(List<Chromosome> chromosomes, int populationLimit) {
        if (chromosomes.size() > populationLimit) {
            throw new IllegalArgumentException("List of chromosomes bigger than maxPopulationSize.");
        }
        if (populationLimit < 0) {
            throw new IllegalArgumentException("Population limit has to be >= 0");
        }
        this.chromosomes = chromosomes;
        this.populationLimit = populationLimit;
    }

    public ListPopulation(int populationLimit) {
        if (populationLimit < 0) {
            throw new IllegalArgumentException("Population limit has to be >= 0");
        }
        this.populationLimit = populationLimit;
        this.chromosomes = new ArrayList<Chromosome>(populationLimit);
    }

    public void setChromosomes(List<Chromosome> chromosomes) {
        this.chromosomes = chromosomes;
    }

    public List<Chromosome> getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public void addChromosome(Chromosome chromosome) {
        this.chromosomes.add(chromosome);
    }

    @Override
    public Chromosome getFittestChromosome() {
        Chromosome bestChromosome = this.chromosomes.get(0);
        for (Chromosome chromosome : this.chromosomes) {
            if (chromosome.compareTo(bestChromosome) <= 0) continue;
            bestChromosome = chromosome;
        }
        return bestChromosome;
    }

    @Override
    public int getPopulationLimit() {
        return this.populationLimit;
    }

    public void setPopulationLimit(int populationLimit) {
        this.populationLimit = populationLimit;
    }

    @Override
    public int getPopulationSize() {
        return this.chromosomes.size();
    }

    public String toString() {
        return this.chromosomes.toString();
    }

    @Override
    public Iterator<Chromosome> iterator() {
        return this.chromosomes.iterator();
    }
}

