/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.linear;

import java.util.Iterator;
import org.apache.pinot.$internal.org.apache.commons.math.FunctionEvaluationException;
import org.apache.pinot.$internal.org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.pinot.$internal.org.apache.commons.math.linear.MatrixIndexException;
import org.apache.pinot.$internal.org.apache.commons.math.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RealVector {
    public RealVector mapToSelf(UnivariateRealFunction var1) throws FunctionEvaluationException;

    public RealVector map(UnivariateRealFunction var1) throws FunctionEvaluationException;

    public Iterator<Entry> iterator();

    public Iterator<Entry> sparseIterator();

    public RealVector copy();

    public RealVector add(RealVector var1) throws IllegalArgumentException;

    public RealVector add(double[] var1) throws IllegalArgumentException;

    public RealVector subtract(RealVector var1) throws IllegalArgumentException;

    public RealVector subtract(double[] var1) throws IllegalArgumentException;

    public RealVector mapAdd(double var1);

    public RealVector mapAddToSelf(double var1);

    public RealVector mapSubtract(double var1);

    public RealVector mapSubtractToSelf(double var1);

    public RealVector mapMultiply(double var1);

    public RealVector mapMultiplyToSelf(double var1);

    public RealVector mapDivide(double var1);

    public RealVector mapDivideToSelf(double var1);

    public RealVector mapPow(double var1);

    public RealVector mapPowToSelf(double var1);

    public RealVector mapExp();

    public RealVector mapExpToSelf();

    public RealVector mapExpm1();

    public RealVector mapExpm1ToSelf();

    public RealVector mapLog();

    public RealVector mapLogToSelf();

    public RealVector mapLog10();

    public RealVector mapLog10ToSelf();

    public RealVector mapLog1p();

    public RealVector mapLog1pToSelf();

    public RealVector mapCosh();

    public RealVector mapCoshToSelf();

    public RealVector mapSinh();

    public RealVector mapSinhToSelf();

    public RealVector mapTanh();

    public RealVector mapTanhToSelf();

    public RealVector mapCos();

    public RealVector mapCosToSelf();

    public RealVector mapSin();

    public RealVector mapSinToSelf();

    public RealVector mapTan();

    public RealVector mapTanToSelf();

    public RealVector mapAcos();

    public RealVector mapAcosToSelf();

    public RealVector mapAsin();

    public RealVector mapAsinToSelf();

    public RealVector mapAtan();

    public RealVector mapAtanToSelf();

    public RealVector mapInv();

    public RealVector mapInvToSelf();

    public RealVector mapAbs();

    public RealVector mapAbsToSelf();

    public RealVector mapSqrt();

    public RealVector mapSqrtToSelf();

    public RealVector mapCbrt();

    public RealVector mapCbrtToSelf();

    public RealVector mapCeil();

    public RealVector mapCeilToSelf();

    public RealVector mapFloor();

    public RealVector mapFloorToSelf();

    public RealVector mapRint();

    public RealVector mapRintToSelf();

    public RealVector mapSignum();

    public RealVector mapSignumToSelf();

    public RealVector mapUlp();

    public RealVector mapUlpToSelf();

    public RealVector ebeMultiply(RealVector var1) throws IllegalArgumentException;

    public RealVector ebeMultiply(double[] var1) throws IllegalArgumentException;

    public RealVector ebeDivide(RealVector var1) throws IllegalArgumentException;

    public RealVector ebeDivide(double[] var1) throws IllegalArgumentException;

    public double[] getData();

    public double dotProduct(RealVector var1) throws IllegalArgumentException;

    public double dotProduct(double[] var1) throws IllegalArgumentException;

    public double getNorm();

    public double getL1Norm();

    public double getLInfNorm();

    public double getDistance(RealVector var1) throws IllegalArgumentException;

    public double getDistance(double[] var1) throws IllegalArgumentException;

    public double getL1Distance(RealVector var1) throws IllegalArgumentException;

    public double getL1Distance(double[] var1) throws IllegalArgumentException;

    public double getLInfDistance(RealVector var1) throws IllegalArgumentException;

    public double getLInfDistance(double[] var1) throws IllegalArgumentException;

    public RealVector unitVector();

    public void unitize();

    public RealVector projection(RealVector var1) throws IllegalArgumentException;

    public RealVector projection(double[] var1) throws IllegalArgumentException;

    public RealMatrix outerProduct(RealVector var1) throws IllegalArgumentException;

    public RealMatrix outerProduct(double[] var1) throws IllegalArgumentException;

    public double getEntry(int var1) throws MatrixIndexException;

    public void setEntry(int var1, double var2) throws MatrixIndexException;

    public int getDimension();

    public RealVector append(RealVector var1);

    public RealVector append(double var1);

    public RealVector append(double[] var1);

    public RealVector getSubVector(int var1, int var2) throws MatrixIndexException;

    public void setSubVector(int var1, RealVector var2) throws MatrixIndexException;

    public void setSubVector(int var1, double[] var2) throws MatrixIndexException;

    public void set(double var1);

    public double[] toArray();

    public boolean isNaN();

    public boolean isInfinite();

    public static abstract class Entry {
        private int index;

        public abstract double getValue();

        public abstract void setValue(double var1);

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

