/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.special;

import org.apache.pinot.$internal.org.apache.commons.math.MathException;
import org.apache.pinot.$internal.org.apache.commons.math.MaxIterationsExceededException;
import org.apache.pinot.$internal.org.apache.commons.math.util.ContinuedFraction;

public class Gamma {
    public static final double GAMMA = 0.5772156649015329;
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;

    private Gamma() {
    }

    public static double logGamma(double x) {
        double ret;
        if (Double.isNaN(x) || x <= 0.0) {
            ret = Double.NaN;
        } else {
            double g = 4.7421875;
            double sum = 0.0;
            for (int i = LANCZOS.length - 1; i > 0; --i) {
                sum += LANCZOS[i] / (x + (double)i);
            }
            double tmp = x + g + 0.5;
            ret = (x + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log((sum += LANCZOS[0]) / x);
        }
        return ret;
    }

    public static double regularizedGammaP(double a, double x) throws MathException {
        return Gamma.regularizedGammaP(a, x, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaP(double a, double x, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 0.0;
        } else if (x >= a + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaQ(a, x, epsilon, maxIterations);
        } else {
            double sum;
            double an;
            double n = 0.0;
            for (sum = an = 1.0 / a; Math.abs(an / sum) > epsilon && n < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x / (a + (n += 1.0)))) {
            }
            if (n >= (double)maxIterations) {
                throw new MaxIterationsExceededException(maxIterations);
            }
            ret = Double.isInfinite(sum) ? 1.0 : Math.exp(-x + a * Math.log(x) - Gamma.logGamma(a)) * sum;
        }
        return ret;
    }

    public static double regularizedGammaQ(double a, double x) throws MathException {
        return Gamma.regularizedGammaQ(a, x, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaQ(final double a, double x, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 1.0;
        } else if (x < a + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaP(a, x, epsilon, maxIterations);
        } else {
            ContinuedFraction cf = new ContinuedFraction(){

                protected double getA(int n, double x) {
                    return 2.0 * (double)n + 1.0 - a + x;
                }

                protected double getB(int n, double x) {
                    return (double)n * (a - (double)n);
                }
            };
            ret = 1.0 / cf.evaluate(x, epsilon, maxIterations);
            ret = Math.exp(-x + a * Math.log(x) - Gamma.logGamma(a)) * ret;
        }
        return ret;
    }

    public static double digamma(double x) {
        if (x > 0.0 && x <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / x;
        }
        if (x >= 49.0) {
            double inv = 1.0 / (x * x);
            return Math.log(x) - 0.5 / x - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / 252.0));
        }
        return Gamma.digamma(x + 1.0) - 1.0 / x;
    }

    public static double trigamma(double x) {
        if (x > 0.0 && x <= 1.0E-5) {
            return 1.0 / (x * x);
        }
        if (x >= 49.0) {
            double inv = 1.0 / (x * x);
            return 1.0 / x + inv / 2.0 + inv / x * (0.16666666666666666 - inv * (0.03333333333333333 + inv / 42.0));
        }
        return Gamma.trigamma(x + 1.0) + 1.0 / (x * x);
    }
}

