/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.common;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.$internal.com.google.common.primitives.Longs;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.AvgPair;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.MinMaxRangePair;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.QuantileDigest;
import org.apache.pinot.common.utils.StringUtil;

public class ObjectSerDeUtils {
    public static final ObjectSerDe<String> STRING_SER_DE = new ObjectSerDe<String>(){

        @Override
        public byte[] serialize(String value) {
            return StringUtil.encodeUtf8(value);
        }

        @Override
        public String deserialize(byte[] bytes) {
            return StringUtil.decodeUtf8(bytes);
        }

        @Override
        public String deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return StringUtil.decodeUtf8(bytes);
        }
    };
    public static final ObjectSerDe<Long> LONG_SER_DE = new ObjectSerDe<Long>(){

        @Override
        public byte[] serialize(Long value) {
            return Longs.toByteArray(value);
        }

        @Override
        public Long deserialize(byte[] bytes) {
            return Longs.fromByteArray(bytes);
        }

        @Override
        public Long deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getLong();
        }
    };
    public static final ObjectSerDe<Double> DOUBLE_SER_DE = new ObjectSerDe<Double>(){

        @Override
        public byte[] serialize(Double value) {
            return Longs.toByteArray(Double.doubleToRawLongBits(value));
        }

        @Override
        public Double deserialize(byte[] bytes) {
            return Double.longBitsToDouble(Longs.fromByteArray(bytes));
        }

        @Override
        public Double deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getDouble();
        }
    };
    public static final ObjectSerDe<DoubleArrayList> DOUBLE_ARRAY_LIST_SER_DE = new ObjectSerDe<DoubleArrayList>(){

        @Override
        public byte[] serialize(DoubleArrayList doubleArrayList) {
            int size = doubleArrayList.size();
            byte[] bytes = new byte[4 + size * 8];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            double[] values = doubleArrayList.elements();
            for (int i = 0; i < size; ++i) {
                byteBuffer.putDouble(values[i]);
            }
            return bytes;
        }

        @Override
        public DoubleArrayList deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public DoubleArrayList deserialize(ByteBuffer byteBuffer) {
            int numValues = byteBuffer.getInt();
            DoubleArrayList doubleArrayList = new DoubleArrayList(numValues);
            for (int i = 0; i < numValues; ++i) {
                doubleArrayList.add(byteBuffer.getDouble());
            }
            return doubleArrayList;
        }
    };
    public static final ObjectSerDe<AvgPair> AVG_PAIR_SER_DE = new ObjectSerDe<AvgPair>(){

        @Override
        public byte[] serialize(AvgPair avgPair) {
            return avgPair.toBytes();
        }

        @Override
        public AvgPair deserialize(byte[] bytes) {
            return AvgPair.fromBytes(bytes);
        }

        @Override
        public AvgPair deserialize(ByteBuffer byteBuffer) {
            return AvgPair.fromByteBuffer(byteBuffer);
        }
    };
    public static final ObjectSerDe<MinMaxRangePair> MIN_MAX_RANGE_PAIR_SER_DE = new ObjectSerDe<MinMaxRangePair>(){

        @Override
        public byte[] serialize(MinMaxRangePair minMaxRangePair) {
            return minMaxRangePair.toBytes();
        }

        @Override
        public MinMaxRangePair deserialize(byte[] bytes) {
            return MinMaxRangePair.fromBytes(bytes);
        }

        @Override
        public MinMaxRangePair deserialize(ByteBuffer byteBuffer) {
            return MinMaxRangePair.fromByteBuffer(byteBuffer);
        }
    };
    public static final ObjectSerDe<HyperLogLog> HYPER_LOG_LOG_SER_DE = new ObjectSerDe<HyperLogLog>(){

        @Override
        public byte[] serialize(HyperLogLog hyperLogLog) {
            try {
                return hyperLogLog.getBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing HyperLogLog", e);
            }
        }

        @Override
        public HyperLogLog deserialize(byte[] bytes) {
            try {
                return HyperLogLog.Builder.build((byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while de-serializing HyperLogLog", e);
            }
        }

        @Override
        public HyperLogLog deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            try {
                return HyperLogLog.Builder.build((byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while de-serializing HyperLogLog", e);
            }
        }
    };
    public static final ObjectSerDe<QuantileDigest> QUANTILE_DIGEST_SER_DE = new ObjectSerDe<QuantileDigest>(){

        @Override
        public byte[] serialize(QuantileDigest quantileDigest) {
            return quantileDigest.toBytes();
        }

        @Override
        public QuantileDigest deserialize(byte[] bytes) {
            return QuantileDigest.fromBytes(bytes);
        }

        @Override
        public QuantileDigest deserialize(ByteBuffer byteBuffer) {
            return QuantileDigest.fromByteBuffer(byteBuffer);
        }
    };
    public static final ObjectSerDe<Map<Object, Object>> MAP_SER_DE = new ObjectSerDe<Map<Object, Object>>(){

        @Override
        public byte[] serialize(Map<Object, Object> map) {
            int size = map.size();
            if (size == 0) {
                return new byte[4];
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(size);
                Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
                Map.Entry<Object, Object> firstEntry = iterator.next();
                Object firstKey = firstEntry.getKey();
                Object firstValue = firstEntry.getValue();
                int keyTypeValue = ObjectType.getObjectType(firstKey).getValue();
                int valueTypeValue = ObjectType.getObjectType(firstValue).getValue();
                dataOutputStream.writeInt(keyTypeValue);
                dataOutputStream.writeInt(valueTypeValue);
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    byte[] keyBytes = ObjectSerDeUtils.serialize(entry.getKey(), keyTypeValue);
                    dataOutputStream.writeInt(keyBytes.length);
                    dataOutputStream.write(keyBytes);
                    byte[] valueBytes = ObjectSerDeUtils.serialize(entry.getValue(), valueTypeValue);
                    dataOutputStream.writeInt(valueBytes.length);
                    dataOutputStream.write(valueBytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing Map", e);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public Map<Object, Object> deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public Map<Object, Object> deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            HashMap<Object, Object> map = new HashMap<Object, Object>(size);
            if (size == 0) {
                return map;
            }
            int keyTypeValue = byteBuffer.getInt();
            int valueTypeValue = byteBuffer.getInt();
            for (int i = 0; i < size; ++i) {
                Object key = ObjectSerDeUtils.deserialize(this.sliceByteBuffer(byteBuffer, byteBuffer.getInt()), keyTypeValue);
                Object value = ObjectSerDeUtils.deserialize(this.sliceByteBuffer(byteBuffer, byteBuffer.getInt()), valueTypeValue);
                map.put(key, value);
            }
            return map;
        }

        private ByteBuffer sliceByteBuffer(ByteBuffer byteBuffer, int size) {
            ByteBuffer slice = byteBuffer.slice();
            slice.limit(size);
            byteBuffer.position(byteBuffer.position() + size);
            return slice;
        }
    };
    public static final ObjectSerDe<IntSet> INT_SET_SER_DE = new ObjectSerDe<IntSet>(){

        @Override
        public byte[] serialize(IntSet intSet) {
            int size = intSet.size();
            byte[] bytes = new byte[4 + size * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            IntIterator iterator = intSet.iterator();
            while (iterator.hasNext()) {
                byteBuffer.putInt(iterator.nextInt());
            }
            return bytes;
        }

        @Override
        public IntSet deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public IntSet deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            IntOpenHashSet intSet = new IntOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                intSet.add(byteBuffer.getInt());
            }
            return intSet;
        }
    };
    public static final ObjectSerDe<TDigest> TDIGEST_SER_DE = new ObjectSerDe<TDigest>(){

        @Override
        public byte[] serialize(TDigest tDigest) {
            byte[] bytes = new byte[tDigest.byteSize()];
            tDigest.asBytes(ByteBuffer.wrap(bytes));
            return bytes;
        }

        @Override
        public TDigest deserialize(byte[] bytes) {
            return MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(bytes));
        }

        @Override
        public TDigest deserialize(ByteBuffer byteBuffer) {
            return MergingDigest.fromBytes((ByteBuffer)byteBuffer);
        }
    };
    private static final ObjectSerDe[] SER_DES = new ObjectSerDe[]{STRING_SER_DE, LONG_SER_DE, DOUBLE_SER_DE, DOUBLE_ARRAY_LIST_SER_DE, AVG_PAIR_SER_DE, MIN_MAX_RANGE_PAIR_SER_DE, HYPER_LOG_LOG_SER_DE, QUANTILE_DIGEST_SER_DE, MAP_SER_DE, INT_SET_SER_DE, TDIGEST_SER_DE};

    private ObjectSerDeUtils() {
    }

    public static byte[] serialize(Object value) {
        return ObjectSerDeUtils.serialize(value, ObjectType.getObjectType(value)._value);
    }

    public static byte[] serialize(Object value, ObjectType objectType) {
        return ObjectSerDeUtils.serialize(value, objectType._value);
    }

    public static byte[] serialize(Object value, int objectTypeValue) {
        return SER_DES[objectTypeValue].serialize(value);
    }

    public static <T> T deserialize(byte[] bytes, ObjectType objectType) {
        return ObjectSerDeUtils.deserialize(bytes, objectType._value);
    }

    public static <T> T deserialize(byte[] bytes, int objectTypeValue) {
        return SER_DES[objectTypeValue].deserialize(bytes);
    }

    public static <T> T deserialize(ByteBuffer byteBuffer, ObjectType objectType) {
        return ObjectSerDeUtils.deserialize(byteBuffer, objectType._value);
    }

    public static <T> T deserialize(ByteBuffer byteBuffer, int objectTypeValue) {
        return SER_DES[objectTypeValue].deserialize(byteBuffer);
    }

    public static interface ObjectSerDe<T> {
        public byte[] serialize(T var1);

        public T deserialize(byte[] var1);

        public T deserialize(ByteBuffer var1);
    }

    public static enum ObjectType {
        String(0),
        Long(1),
        Double(2),
        DoubleArrayList(3),
        AvgPair(4),
        MinMaxRangePair(5),
        HyperLogLog(6),
        QuantileDigest(7),
        Map(8),
        IntSet(9),
        TDigest(10);

        private int _value;

        private ObjectType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }

        public static ObjectType getObjectType(Object value) {
            if (value instanceof String) {
                return String;
            }
            if (value instanceof Long) {
                return Long;
            }
            if (value instanceof Double) {
                return Double;
            }
            if (value instanceof DoubleArrayList) {
                return DoubleArrayList;
            }
            if (value instanceof AvgPair) {
                return AvgPair;
            }
            if (value instanceof MinMaxRangePair) {
                return MinMaxRangePair;
            }
            if (value instanceof HyperLogLog) {
                return HyperLogLog;
            }
            if (value instanceof QuantileDigest) {
                return QuantileDigest;
            }
            if (value instanceof Map) {
                return Map;
            }
            if (value instanceof IntSet) {
                return IntSet;
            }
            if (value instanceof TDigest) {
                return TDigest;
            }
            throw new IllegalArgumentException("Unsupported type of value: " + value.getClass().getSimpleName());
        }
    }
}

