/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.common.datatable;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;

public class DataTableBuilder {
    private final DataSchema _dataSchema;
    private final int[] _columnOffsets;
    private final int _rowSizeInBytes;
    private final Map<String, Map<String, Integer>> _dictionaryMap = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<Integer, String>> _reverseDictionaryMap = new HashMap<String, Map<Integer, String>>();
    private final ByteArrayOutputStream _fixedSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream _variableSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream _variableSizeDataOutputStream = new DataOutputStream(this._variableSizeDataByteArrayOutputStream);
    private int _numRows;
    private ByteBuffer _currentRowDataByteBuffer;

    public DataTableBuilder(@Nonnull DataSchema dataSchema) {
        this._dataSchema = dataSchema;
        this._columnOffsets = new int[dataSchema.size()];
        this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(dataSchema, this._columnOffsets);
    }

    public void startRow() {
        ++this._numRows;
        this._currentRowDataByteBuffer = ByteBuffer.allocate(this._rowSizeInBytes);
    }

    public void setColumn(int colId, boolean value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        if (value) {
            this._currentRowDataByteBuffer.put((byte)1);
        } else {
            this._currentRowDataByteBuffer.put((byte)0);
        }
    }

    public void setColumn(int colId, byte value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.put(value);
    }

    public void setColumn(int colId, char value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putChar(value);
    }

    public void setColumn(int colId, short value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putShort(value);
    }

    public void setColumn(int colId, int value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(value);
    }

    public void setColumn(int colId, long value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putLong(value);
    }

    public void setColumn(int colId, float value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putFloat(value);
    }

    public void setColumn(int colId, double value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putDouble(value);
    }

    public void setColumn(int colId, @Nonnull String value) {
        String columnName = this._dataSchema.getColumnName(colId);
        Map<String, Integer> dictionary = this._dictionaryMap.get(columnName);
        if (dictionary == null) {
            dictionary = new HashMap<String, Integer>();
            this._dictionaryMap.put(columnName, dictionary);
            this._reverseDictionaryMap.put(columnName, new HashMap());
        }
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        Integer dictId = dictionary.get(value);
        if (dictId == null) {
            dictId = dictionary.size();
            dictionary.put(value, dictId);
            this._reverseDictionaryMap.get(columnName).put(dictId, value);
        }
        this._currentRowDataByteBuffer.putInt(dictId);
    }

    public void setColumn(int colId, @Nonnull Object value) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
        byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
        this._currentRowDataByteBuffer.putInt(bytes.length);
        this._variableSizeDataOutputStream.writeInt(objectTypeValue);
        this._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    public void setColumn(int colId, @Nonnull byte[] values) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (byte value : values) {
            this._variableSizeDataByteArrayOutputStream.write(value);
        }
    }

    public void setColumn(int colId, @Nonnull char[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (char value : values) {
            this._variableSizeDataOutputStream.writeChar(value);
        }
    }

    public void setColumn(int colId, @Nonnull short[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (short value : values) {
            this._variableSizeDataOutputStream.writeShort(value);
        }
    }

    public void setColumn(int colId, @Nonnull int[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (int value : values) {
            this._variableSizeDataOutputStream.writeInt(value);
        }
    }

    public void setColumn(int colId, @Nonnull long[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (long value : values) {
            this._variableSizeDataOutputStream.writeLong(value);
        }
    }

    public void setColumn(int colId, @Nonnull float[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (float value : values) {
            this._variableSizeDataOutputStream.writeFloat(value);
        }
    }

    public void setColumn(int colId, @Nonnull double[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (double value : values) {
            this._variableSizeDataOutputStream.writeDouble(value);
        }
    }

    public void setColumn(int colId, @Nonnull String[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        String columnName = this._dataSchema.getColumnName(colId);
        Map<String, Integer> dictionary = this._dictionaryMap.get(columnName);
        if (dictionary == null) {
            dictionary = new HashMap<String, Integer>();
            this._dictionaryMap.put(columnName, dictionary);
            this._reverseDictionaryMap.put(columnName, new HashMap());
        }
        for (String value : values) {
            Integer dictId = dictionary.get(value);
            if (dictId == null) {
                dictId = dictionary.size();
                dictionary.put(value, dictId);
                this._reverseDictionaryMap.get(columnName).put(dictId, value);
            }
            this._variableSizeDataOutputStream.writeInt(dictId);
        }
    }

    public void finishRow() throws IOException {
        this._fixedSizeDataByteArrayOutputStream.write(this._currentRowDataByteBuffer.array());
    }

    public DataTable build() {
        return new DataTableImplV2(this._numRows, this._dataSchema, this._reverseDictionaryMap, this._fixedSizeDataByteArrayOutputStream.toByteArray(), this._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    public static DataTable buildEmptyDataTable(BrokerRequest brokerRequest) throws IOException {
        if (brokerRequest.isSetSelections()) {
            Selection selection = brokerRequest.getSelections();
            List<String> selectionColumns = selection.getSelectionColumns();
            int numSelectionColumns = selectionColumns.size();
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numSelectionColumns];
            Arrays.fill((Object[])columnDataTypes, (Object)DataSchema.ColumnDataType.STRING);
            DataSchema dataSchema = new DataSchema(selectionColumns.toArray(new String[numSelectionColumns]), columnDataTypes);
            return new DataTableBuilder(dataSchema).build();
        }
        List<AggregationInfo> aggregationsInfo = brokerRequest.getAggregationsInfo();
        int numAggregations = aggregationsInfo.size();
        AggregationFunctionContext[] aggregationFunctionContexts = new AggregationFunctionContext[numAggregations];
        for (int i = 0; i < numAggregations; ++i) {
            aggregationFunctionContexts[i] = AggregationFunctionUtils.getAggregationFunctionContext(aggregationsInfo.get(i));
        }
        if (brokerRequest.isSetGroupBy()) {
            String[] columnNames = new String[]{"functionName", "GroupByResultMap"};
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING, DataSchema.ColumnDataType.OBJECT};
            DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
            for (int i = 0; i < numAggregations; ++i) {
                dataTableBuilder.startRow();
                dataTableBuilder.setColumn(0, aggregationFunctionContexts[i].getAggregationColumnName());
                dataTableBuilder.setColumn(1, new HashMap());
                dataTableBuilder.finishRow();
            }
            return dataTableBuilder.build();
        }
        String[] aggregationColumnNames = new String[numAggregations];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregations];
        Object[] aggregationResults = new Object[numAggregations];
        for (int i = 0; i < numAggregations; ++i) {
            AggregationFunctionContext aggregationFunctionContext = aggregationFunctionContexts[i];
            aggregationColumnNames[i] = aggregationFunctionContext.getAggregationColumnName();
            AggregationFunction aggregationFunction = aggregationFunctionContext.getAggregationFunction();
            columnDataTypes[i] = aggregationFunction.getIntermediateResultColumnType();
            aggregationResults[i] = aggregationFunction.extractAggregationResult(aggregationFunction.createAggregationResultHolder());
        }
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(aggregationColumnNames, columnDataTypes));
        dataTableBuilder.startRow();
        block8: for (int i = 0; i < numAggregations; ++i) {
            switch (columnDataTypes[i]) {
                case LONG: {
                    dataTableBuilder.setColumn(i, ((Number)aggregationResults[i]).longValue());
                    continue block8;
                }
                case DOUBLE: {
                    dataTableBuilder.setColumn(i, (Double)aggregationResults[i]);
                    continue block8;
                }
                case OBJECT: {
                    dataTableBuilder.setColumn(i, aggregationResults[i]);
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation column data type: " + (Object)((Object)columnDataTypes[i]) + " for column: " + aggregationColumnNames[i]);
                }
            }
        }
        dataTableBuilder.finishRow();
        return dataTableBuilder.build();
    }
}

