/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.common.predicate;

import java.util.Arrays;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;

public class RangePredicate
extends Predicate {
    public static final String DELIMITER = "\t\t";
    public static final String LOWER_INCLUSIVE = "[";
    public static final String LOWER_EXCLUSIVE = "(";
    public static final String UPPER_INCLUSIVE = "]";
    public static final String UPPER_EXCLUSIVE = ")";
    public static final String UNBOUNDED = "*";
    private final boolean incLower;
    private final boolean incUpper;
    private final String lowerBoundary;
    private final String upperBoundary;

    public RangePredicate(String lhs, List<String> rhs) {
        super(lhs, Predicate.Type.RANGE, rhs);
        String rangeString = rhs.get(0).trim();
        this.lowerBoundary = rangeString.split(DELIMITER)[0].substring(1, rangeString.split(DELIMITER)[0].length());
        this.upperBoundary = rangeString.split(DELIMITER)[1].substring(0, rangeString.split(DELIMITER)[1].length() - 1);
        this.incLower = rangeString.trim().startsWith(LOWER_EXCLUSIVE) ? this.lowerBoundary.equals(UNBOUNDED) : true;
        this.incUpper = rangeString.trim().endsWith(UPPER_EXCLUSIVE) ? this.upperBoundary.equals(UNBOUNDED) : true;
    }

    @Override
    public String toString() {
        return "Predicate: type: " + (Object)((Object)this.getType()) + ", left : " + this.getLhs() + ", right : " + Arrays.toString(this.getRhs().toArray(new String[0])) + "\n";
    }

    public boolean includeLowerBoundary() {
        return this.incLower;
    }

    public boolean includeUpperBoundary() {
        return this.incUpper;
    }

    public String getLowerBoundary() {
        return this.lowerBoundary;
    }

    public String getUpperBoundary() {
        return this.upperBoundary;
    }
}

