/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.crypt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.crypt.NoOpPinotCrypter;
import org.apache.pinot.$internal.org.apache.pinot.core.crypt.PinotCrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotCrypterFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotCrypterFactory.class);
    private static Map<String, PinotCrypter> _crypterMap = new HashMap<String, PinotCrypter>();
    private static final String NOOP_PINOT_CRYPTER = "nooppinotcrypter";
    private static final String CLASS = "class";

    private PinotCrypterFactory() {
    }

    public static void init(Configuration config) {
        Iterator keys = config.subset(CLASS).getKeys();
        if (!keys.hasNext()) {
            LOGGER.info("Did not find any crypter classes in the configuration");
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String className = (String)config.getProperty("class." + key);
            LOGGER.info("Got crypter class name {}, full crypter path {}, starting to initialize", (Object)key, (Object)className);
            try {
                PinotCrypter pinotCrypter = (PinotCrypter)Class.forName(className).newInstance();
                pinotCrypter.init(config.subset(key));
                LOGGER.info("Initializing PinotCrypter for scheme {}, classname {}", (Object)key, (Object)className);
                _crypterMap.put(key.toLowerCase(), pinotCrypter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("Could not instantiate crypter for class {}", (Object)className, (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (!_crypterMap.containsKey(NOOP_PINOT_CRYPTER)) {
            LOGGER.info("NoOpPinotCrypter not configured, adding as default");
            _crypterMap.put(NOOP_PINOT_CRYPTER, new NoOpPinotCrypter());
        }
    }

    public static PinotCrypter create(String crypterClassName) {
        PinotCrypter pinotCrypter = _crypterMap.get(crypterClassName.toLowerCase());
        if (pinotCrypter == null) {
            throw new RuntimeException("Pinot crypter not configured for class name: " + crypterClassName);
        }
        return pinotCrypter;
    }
}

