/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.data.RowEvent;
import org.apache.pinot.common.utils.JsonUtils;

public class GenericRow
implements RowEvent {
    private Map<String, Object> _fieldMap = new HashMap<String, Object>();

    @Override
    public void init(Map<String, Object> field) {
        this._fieldMap = field;
    }

    public Set<Map.Entry<String, Object>> getEntrySet() {
        return this._fieldMap.entrySet();
    }

    @Override
    public String[] getFieldNames() {
        return this._fieldMap.keySet().toArray(new String[this._fieldMap.size()]);
    }

    @Override
    public Object getValue(String fieldName) {
        return this._fieldMap.get(fieldName);
    }

    public void putField(String key, Object value) {
        this._fieldMap.put(key, value);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (String key : this._fieldMap.keySet()) {
            Object value = this._fieldMap.get(key);
            b.append(key);
            b.append(" : ");
            if (value instanceof Object[]) {
                b.append(Arrays.toString((Object[])value));
            } else {
                b.append(value);
            }
            b.append(", ");
        }
        return b.toString();
    }

    public int hashCode() {
        return this._fieldMap.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenericRow)) {
            return false;
        }
        GenericRow r = (GenericRow)o;
        return this._fieldMap.equals(r._fieldMap);
    }

    public void clear() {
        for (Map.Entry<String, Object> mapEntry : this.getEntrySet()) {
            mapEntry.setValue(null);
        }
    }

    public static GenericRow fromBytes(byte[] buffer) throws IOException {
        Map fieldMap = JsonUtils.bytesToObject(buffer, Map.class);
        GenericRow genericRow = new GenericRow();
        genericRow.init(fieldMap);
        return genericRow;
    }

    public byte[] toBytes() throws IOException {
        return JsonUtils.objectToBytes(this._fieldMap);
    }

    public static GenericRow createOrReuseRow(GenericRow row) {
        if (row == null) {
            return new GenericRow();
        }
        row.clear();
        return row;
    }
}

