/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.function;

import java.util.List;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.function.FunctionInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.data.function.FunctionInvoker;
import org.apache.pinot.$internal.org.apache.pinot.core.data.function.FunctionRegistry;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class FunctionExpressionEvaluator {
    private final ExecutableNode _rootNode;

    public FunctionExpressionEvaluator(String expression) throws Exception {
        this._rootNode = this.planExecution(TransformExpressionTree.compileToExpressionTree(expression));
    }

    private ExecutableNode planExecution(TransformExpressionTree expressionTree) throws Exception {
        String transformName = expressionTree.getValue();
        List<TransformExpressionTree> children = expressionTree.getChildren();
        Class[] argumentTypes = new Class[children.size()];
        ExecutableNode[] childNodes = new ExecutableNode[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            ExecutableNode childNode;
            TransformExpressionTree childExpression = children.get(i);
            switch (childExpression.getExpressionType()) {
                case FUNCTION: {
                    childNode = this.planExecution(childExpression);
                    break;
                }
                case IDENTIFIER: {
                    childNode = new ColumnExecutionNode(childExpression.getValue());
                    break;
                }
                case LITERAL: {
                    childNode = new ConstantExecutionNode(childExpression.getValue());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported expression type:" + (Object)((Object)childExpression.getExpressionType()));
                }
            }
            childNodes[i] = childNode;
            argumentTypes[i] = childNode.getReturnType();
        }
        FunctionInfo functionInfo = FunctionRegistry.resolve(transformName, argumentTypes);
        return new FunctionExecutionNode(functionInfo, childNodes);
    }

    public Object evaluate(GenericRow row) {
        return this._rootNode.execute(row);
    }

    private static class ColumnExecutionNode
    implements ExecutableNode {
        private String _column;

        public ColumnExecutionNode(String column) {
            this._column = column;
        }

        @Override
        public Object execute(GenericRow row) {
            return row.getValue(this._column);
        }

        @Override
        public Class<?> getReturnType() {
            return Object.class;
        }
    }

    private static class ConstantExecutionNode
    implements ExecutableNode {
        private String _value;

        public ConstantExecutionNode(String value) {
            this._value = value;
        }

        @Override
        public Object execute(GenericRow row) {
            return this._value;
        }

        @Override
        public Class<?> getReturnType() {
            return String.class;
        }
    }

    private static class FunctionExecutionNode
    implements ExecutableNode {
        FunctionInvoker _functionInvoker;
        ExecutableNode[] _argumentProviders;
        Object[] _argInputs;

        public FunctionExecutionNode(FunctionInfo functionInfo, ExecutableNode[] argumentProviders) throws Exception {
            Preconditions.checkNotNull(functionInfo);
            Preconditions.checkNotNull(argumentProviders);
            this._functionInvoker = new FunctionInvoker(functionInfo);
            this._argumentProviders = argumentProviders;
            this._argInputs = new Object[this._argumentProviders.length];
        }

        @Override
        public Object execute(GenericRow row) {
            for (int i = 0; i < this._argumentProviders.length; ++i) {
                this._argInputs[i] = this._argumentProviders[i].execute(row);
            }
            return this._functionInvoker.process(this._argInputs);
        }

        @Override
        public Class<?> getReturnType() {
            return this._functionInvoker.getReturnType();
        }
    }

    private static interface ExecutableNode {
        public Object execute(GenericRow var1);

        public Class<?> getReturnType();
    }
}

