/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.function;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.org.apache.pinot.core.data.function.FunctionInfo;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionInvoker.class);
    private static long EXCEPTION_LIMIT_DURATION = TimeUnit.MINUTES.toMillis(5L);
    private static long EXCEPTION_LIMIT_RATE = 10L;
    private Method _method;
    private Object _instance;
    private int exceptionCount;
    private long lastExceptionTime = 0L;
    private FunctionInfo _functionInfo;

    public FunctionInvoker(FunctionInfo functionInfo) throws Exception {
        this._functionInfo = functionInfo;
        this._method = functionInfo.getMethod();
        Class<?> clazz = functionInfo.getClazz();
        this._instance = Modifier.isStatic(this._method.getModifiers()) ? null : clazz.newInstance();
    }

    public Class<?>[] getParameterTypes() {
        return this._method.getParameterTypes();
    }

    public Class<?> getReturnType() {
        return this._method.getReturnType();
    }

    public Object process(Object[] args) {
        try {
            return this._method.invoke(this._instance, this._functionInfo.convertTypes(args));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (Duration.millis((long)(System.currentTimeMillis() - this.lastExceptionTime)).getStandardMinutes() > EXCEPTION_LIMIT_DURATION) {
                this.exceptionCount = 0;
            }
            if ((long)this.exceptionCount < EXCEPTION_LIMIT_RATE) {
                ++this.exceptionCount;
                LOGGER.error("Exception invoking method:{} with args:{}, exception message: {}", new Object[]{this._method.getName(), Arrays.toString(args), cause.getMessage()});
            }
            return null;
        }
    }
}

