/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.SegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.TableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.config.TableDataManagerConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseTableDataManager
implements TableDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableDataManager.class);
    protected final ConcurrentHashMap<String, SegmentDataManager> _segmentDataManagerMap = new ConcurrentHashMap();
    protected TableDataManagerConfig _tableDataManagerConfig;
    protected String _instanceId;
    protected ZkHelixPropertyStore<ZNRecord> _propertyStore;
    protected ServerMetrics _serverMetrics;
    protected String _tableNameWithType;
    protected String _tableDataDir;
    protected File _indexDir;
    protected Logger _logger;

    @Override
    public void init(@Nonnull TableDataManagerConfig tableDataManagerConfig, @Nonnull String instanceId, @Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull ServerMetrics serverMetrics) {
        LOGGER.info("Initializing table data manager for table: {}", (Object)tableDataManagerConfig.getTableName());
        this._tableDataManagerConfig = tableDataManagerConfig;
        this._instanceId = instanceId;
        this._propertyStore = propertyStore;
        this._serverMetrics = serverMetrics;
        this._tableNameWithType = tableDataManagerConfig.getTableName();
        this._tableDataDir = tableDataManagerConfig.getDataDir();
        this._indexDir = new File(this._tableDataDir);
        if (!this._indexDir.exists()) {
            Preconditions.checkState(this._indexDir.mkdirs());
        }
        this._logger = LoggerFactory.getLogger((String)(this._tableNameWithType + "-" + this.getClass().getSimpleName()));
        this.doInit();
        this._logger.info("Initialized table data manager for table: {} with data directory: {}", (Object)this._tableNameWithType, (Object)this._tableDataDir);
    }

    protected abstract void doInit();

    @Override
    public void start() {
        this._logger.info("Starting table data manager for table: {}", (Object)this._tableNameWithType);
        this.doStart();
        this._logger.info("Started table data manager for table: {}", (Object)this._tableNameWithType);
    }

    protected abstract void doStart();

    @Override
    public void shutDown() {
        this._logger.info("Shutting down table data manager for table: {}", (Object)this._tableNameWithType);
        this.doShutdown();
        this._logger.info("Shut down table data manager for table: {}", (Object)this._tableNameWithType);
    }

    protected abstract void doShutdown();

    @Override
    public void addSegment(@Nonnull ImmutableSegment immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        this._logger.info("Adding immutable segment: {} to table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, ServerGauge.DOCUMENT_COUNT, immutableSegment.getSegmentMetadata().getTotalRawDocs());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, ServerGauge.SEGMENT_COUNT, 1L);
        ImmutableSegmentDataManager newSegmentManager = new ImmutableSegmentDataManager(immutableSegment);
        SegmentDataManager oldSegmentManager = this._segmentDataManagerMap.put(segmentName, newSegmentManager);
        if (oldSegmentManager == null) {
            this._logger.info("Added new immutable segment: {} to table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Replaced immutable segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
            this.releaseSegment(oldSegmentManager);
        }
    }

    @Override
    public void addSegment(@Nonnull File indexDir, @Nonnull IndexLoadingConfig indexLoadingConfig) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSegment(@Nonnull String segmentName, @Nonnull TableConfig tableConfig, @Nonnull IndexLoadingConfig indexLoadingConfig) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSegment(@Nonnull String segmentName) {
        this._logger.info("Removing segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        SegmentDataManager segmentDataManager = this._segmentDataManagerMap.remove(segmentName);
        if (segmentDataManager != null) {
            this.releaseSegment(segmentDataManager);
            this._logger.info("Removed segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Failed to find segment: {} in table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        }
    }

    @Override
    @Nonnull
    public List<SegmentDataManager> acquireAllSegments() {
        ArrayList<SegmentDataManager> segmentDataManagers = new ArrayList<SegmentDataManager>();
        for (SegmentDataManager segmentDataManager : this._segmentDataManagerMap.values()) {
            if (!segmentDataManager.increaseReferenceCount()) continue;
            segmentDataManagers.add(segmentDataManager);
        }
        return segmentDataManagers;
    }

    @Override
    @Nonnull
    public List<SegmentDataManager> acquireSegments(@Nonnull List<String> segmentNames) {
        ArrayList<SegmentDataManager> segmentDataManagers = new ArrayList<SegmentDataManager>();
        for (String segmentName : segmentNames) {
            SegmentDataManager segmentDataManager = this._segmentDataManagerMap.get(segmentName);
            if (segmentDataManager != null && segmentDataManager.increaseReferenceCount()) {
                segmentDataManagers.add(segmentDataManager);
                continue;
            }
            this.handleMissingSegment(segmentName);
        }
        return segmentDataManagers;
    }

    @Override
    public SegmentDataManager acquireSegment(@Nonnull String segmentName) {
        SegmentDataManager segmentDataManager = this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager != null && segmentDataManager.increaseReferenceCount()) {
            return segmentDataManager;
        }
        this.handleMissingSegment(segmentName);
        return null;
    }

    private void handleMissingSegment(String segmentName) {
        LOGGER.error("Could not find segment " + segmentName + " for table " + this._tableNameWithType);
        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, ServerMeter.NUM_MISSING_SEGMENTS, 1L);
    }

    @Override
    public void releaseSegment(@Nonnull SegmentDataManager segmentDataManager) {
        if (segmentDataManager.decreaseReferenceCount()) {
            this.closeSegment(segmentDataManager);
        }
    }

    private void closeSegment(@Nonnull SegmentDataManager segmentDataManager) {
        String segmentName = segmentDataManager.getSegmentName();
        this._logger.info("Closing segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, ServerGauge.SEGMENT_COUNT, -1L);
        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, ServerMeter.DELETED_SEGMENT_COUNT, 1L);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, ServerGauge.DOCUMENT_COUNT, -segmentDataManager.getSegment().getSegmentMetadata().getTotalRawDocs());
        segmentDataManager.destroy();
        this._logger.info("Closed segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this._tableNameWithType;
    }
}

