/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.TableDataManager;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.segment.SegmentMetadata;

@ThreadSafe
public interface InstanceDataManager {
    public void init(@Nonnull Configuration var1, @Nonnull ZkHelixPropertyStore<ZNRecord> var2, @Nonnull ServerMetrics var3) throws ConfigurationException;

    public void start();

    public void shutDown();

    public void addOfflineSegment(@Nonnull String var1, @Nonnull String var2, @Nonnull File var3) throws Exception;

    public void addRealtimeSegment(@Nonnull String var1, @Nonnull String var2) throws Exception;

    public void removeSegment(@Nonnull String var1, @Nonnull String var2) throws Exception;

    public void reloadSegment(@Nonnull String var1, @Nonnull String var2) throws Exception;

    public void reloadAllSegments(@Nonnull String var1) throws Exception;

    @Nonnull
    public Set<String> getAllTables();

    @Nullable
    public TableDataManager getTableDataManager(@Nonnull String var1);

    @Nullable
    public SegmentMetadata getSegmentMetadata(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public List<SegmentMetadata> getAllSegmentsMetadata(@Nonnull String var1);

    @Nonnull
    public String getSegmentDataDirectory();

    @Nonnull
    public String getSegmentFileDirectory();

    public int getMaxParallelRefreshThreads();
}

