/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.SegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.HLRealtimeSegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.segment.fetcher.SegmentFetcherFactory;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.NamedThreadFactory;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.TarGzCompressionUtils;

@ThreadSafe
public class RealtimeTableDataManager
extends BaseTableDataManager {
    private final ExecutorService _segmentAsyncExecutorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("SegmentAsyncExecutorService"));
    private SegmentBuildTimeLeaseExtender _leaseExtender;
    private RealtimeSegmentStatsHistory _statsHistory;
    private final Semaphore _segmentBuildSemaphore;
    private static final String STATS_FILE_NAME = "segment-stats.ser";
    private static final String CONSUMERS_DIR = "consumers";
    private static final int MIN_INTERVAL_BETWEEN_STATS_UPDATES_MINUTES = 30;

    public RealtimeTableDataManager(Semaphore segmentBuildSemaphore) {
        this._segmentBuildSemaphore = segmentBuildSemaphore;
    }

    @Override
    protected void doInit() {
        this._leaseExtender = SegmentBuildTimeLeaseExtender.create(this._instanceId, this._serverMetrics);
        File statsFile = new File(this._tableDataDir, STATS_FILE_NAME);
        try {
            this._statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom(statsFile);
        }
        catch (IOException | ClassNotFoundException e) {
            this._logger.error("Error reading history object for table {} from {}", new Object[]{this._tableNameWithType, statsFile.getAbsolutePath(), e});
            File savedFile = new File(this._tableDataDir, "segment-stats.ser." + UUID.randomUUID());
            try {
                FileUtils.moveFile(statsFile, savedFile);
            }
            catch (IOException e1) {
                this._logger.error("Could not move {} to {}", new Object[]{statsFile.getAbsolutePath(), savedFile.getAbsolutePath(), e1});
                throw new RuntimeException(e);
            }
            this._logger.warn("Saved unreadable {} into {}. Creating a fresh instance", (Object)statsFile.getAbsolutePath(), (Object)savedFile.getAbsolutePath());
            try {
                this._statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom(statsFile);
            }
            catch (Exception e2) {
                Utils.rethrowException(e2);
            }
        }
        this._statsHistory.setMinIntervalBetweenUpdatesMillis(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES));
        String consumerDirPath = this.getConsumerDir();
        File consumerDir = new File(consumerDirPath);
        if (consumerDir.exists()) {
            File[] segmentFiles;
            for (File file : segmentFiles = consumerDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.equals(RealtimeTableDataManager.STATS_FILE_NAME);
                }
            })) {
                if (file.delete()) {
                    this._logger.info("Deleted old file {}", (Object)file.getAbsolutePath());
                    continue;
                }
                this._logger.error("Cannot delete file {}", (Object)file.getAbsolutePath());
            }
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doShutdown() {
        this._segmentAsyncExecutorService.shutdown();
        for (SegmentDataManager segmentDataManager : this._segmentDataManagerMap.values()) {
            segmentDataManager.destroy();
        }
        if (this._leaseExtender != null) {
            this._leaseExtender.shutDown();
        }
    }

    public RealtimeSegmentStatsHistory getStatsHistory() {
        return this._statsHistory;
    }

    public Semaphore getSegmentBuildSemaphore() {
        return this._segmentBuildSemaphore;
    }

    public String getConsumerDir() {
        File consumerDir;
        String consumerDirPath = this._tableDataManagerConfig.getConsumerDir();
        if (consumerDirPath != null) {
            consumerDir = new File(consumerDirPath, this._tableNameWithType);
        } else {
            consumerDirPath = this._tableDataDir + File.separator + CONSUMERS_DIR;
            consumerDir = new File(consumerDirPath);
        }
        if (!consumerDir.exists() && !consumerDir.mkdirs()) {
            this._logger.error("Failed to create consumer directory {}", (Object)consumerDir.getAbsolutePath());
        }
        return consumerDir.getAbsolutePath();
    }

    public void notifySegmentCommitted(RealtimeSegmentZKMetadata metadata, ImmutableSegment segment) {
        ZKMetadataProvider.setRealtimeSegmentZKMetadata((ZkHelixPropertyStore<ZNRecord>)this._propertyStore, metadata);
        this.addSegment(segment);
    }

    @Override
    public void addSegment(@Nonnull String segmentName, @Nonnull TableConfig tableConfig, @Nonnull IndexLoadingConfig indexLoadingConfig) throws Exception {
        RealtimeSegmentZKMetadata realtimeSegmentZKMetadata = ZKMetadataProvider.getRealtimeSegmentZKMetadata((ZkHelixPropertyStore<ZNRecord>)this._propertyStore, this._tableNameWithType, segmentName);
        Preconditions.checkNotNull(realtimeSegmentZKMetadata);
        File indexDir = new File(this._indexDir, segmentName);
        LoaderUtils.reloadFailureRecovery(indexDir);
        if (indexDir.exists() && realtimeSegmentZKMetadata.getStatus() == CommonConstants.Segment.Realtime.Status.DONE) {
            SegmentDataManager segmentDataManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
            if (segmentDataManager != null) {
                this._logger.warn("Got reload for segment already on disk {} table {}, have {}", new Object[]{segmentName, this._tableNameWithType, segmentDataManager.getClass().getSimpleName()});
                return;
            }
            ImmutableSegment segment = ImmutableSegmentLoader.load(indexDir, indexLoadingConfig);
            this.addSegment(segment);
        } else {
            RealtimeSegmentDataManager manager;
            SegmentDataManager segmentDataManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
            if (segmentDataManager != null) {
                this._logger.warn("Got reload for segment not on disk {} table {}, have {}", new Object[]{segmentName, this._tableNameWithType, segmentDataManager.getClass().getSimpleName()});
                return;
            }
            Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore<ZNRecord>)this._propertyStore, TableNameBuilder.REALTIME.tableNameWithType(this._tableNameWithType));
            Preconditions.checkNotNull(schema);
            if (!this.isValid(schema, tableConfig.getIndexingConfig())) {
                this._logger.error("Not adding segment {}", (Object)segmentName);
                throw new RuntimeException("Mismatching schema/table config for " + this._tableNameWithType);
            }
            VirtualColumnProviderFactory.addBuiltInVirtualColumnsToSchema(schema);
            InstanceZKMetadata instanceZKMetadata = ZKMetadataProvider.getInstanceZKMetadata((ZkHelixPropertyStore<ZNRecord>)this._propertyStore, this._instanceId);
            if (SegmentName.isHighLevelConsumerSegmentName(segmentName)) {
                manager = new HLRealtimeSegmentDataManager(realtimeSegmentZKMetadata, tableConfig, instanceZKMetadata, this, this._indexDir.getAbsolutePath(), indexLoadingConfig, schema, this._serverMetrics);
            } else {
                LLCRealtimeSegmentZKMetadata llcSegmentMetadata = (LLCRealtimeSegmentZKMetadata)realtimeSegmentZKMetadata;
                if (realtimeSegmentZKMetadata.getStatus().equals((Object)CommonConstants.Segment.Realtime.Status.DONE)) {
                    this.downloadAndReplaceSegment(segmentName, llcSegmentMetadata, indexLoadingConfig);
                    return;
                }
                manager = new LLRealtimeSegmentDataManager(realtimeSegmentZKMetadata, tableConfig, instanceZKMetadata, this, this._indexDir.getAbsolutePath(), indexLoadingConfig, schema, this._serverMetrics);
            }
            this._logger.info("Initialize RealtimeSegmentDataManager - " + segmentName);
            this._segmentDataManagerMap.put(segmentName, manager);
        }
    }

    public void downloadAndReplaceSegment(@Nonnull String segmentName, @Nonnull LLCRealtimeSegmentZKMetadata llcSegmentMetadata, @Nonnull IndexLoadingConfig indexLoadingConfig) {
        String uri = llcSegmentMetadata.getDownloadUrl();
        File tempSegmentFolder = new File(this._indexDir, "tmp-" + segmentName + "." + String.valueOf(System.currentTimeMillis()));
        File tempFile = new File(this._indexDir, segmentName + ".tar.gz");
        File segmentFolder = new File(this._indexDir, segmentName);
        FileUtils.deleteQuietly(segmentFolder);
        try {
            SegmentFetcherFactory.getInstance().getSegmentFetcherBasedOnURI(uri).fetchSegmentToLocal(uri, tempFile);
            this._logger.info("Downloaded file from {} to {}; Length of downloaded file: {}", new Object[]{uri, tempFile, tempFile.length()});
            TarGzCompressionUtils.unTar(tempFile, tempSegmentFolder);
            this._logger.info("Uncompressed file {} into tmp dir {}", (Object)tempFile, (Object)tempSegmentFolder);
            FileUtils.moveDirectory(tempSegmentFolder.listFiles()[0], segmentFolder);
            this._logger.info("Replacing LLC Segment {}", (Object)segmentName);
            this.replaceLLSegment(segmentName, indexLoadingConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly(tempFile);
            FileUtils.deleteQuietly(tempSegmentFolder);
        }
    }

    public void replaceLLSegment(@Nonnull String segmentName, @Nonnull IndexLoadingConfig indexLoadingConfig) {
        try {
            ImmutableSegment indexSegment = ImmutableSegmentLoader.load(new File(this._indexDir, segmentName), indexLoadingConfig);
            this.addSegment(indexSegment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getServerInstance() {
        return this._instanceId;
    }

    private boolean isValid(Schema schema, IndexingConfig indexingConfig) {
        List<String> sortedColumns = indexingConfig.getSortedColumn();
        boolean isValid = true;
        if (!sortedColumns.isEmpty()) {
            FieldSpec fieldSpec;
            String sortedColumn = sortedColumns.get(0);
            if (sortedColumns.size() > 1) {
                this._logger.warn("More than one sorted column configured. Using {}", (Object)sortedColumn);
            }
            if (!(fieldSpec = schema.getFieldSpecFor(sortedColumn)).isSingleValueField()) {
                this._logger.error("Cannot configure multi-valued column {} as sorted column", (Object)sortedColumn);
                isValid = false;
            }
        }
        if (!schema.validate(this._logger)) {
            isValid = false;
        }
        return isValid;
    }
}

