/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.partition;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.ByteArrayPartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.ModuloPartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.MurmurPartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;

public class PartitionFunctionFactory {
    private PartitionFunctionFactory() {
    }

    public static PartitionFunction getPartitionFunction(@Nonnull String functionName, int numPartitions) {
        PartitionFunctionType function = PartitionFunctionType.fromString(functionName);
        switch (function) {
            case Modulo: {
                return new ModuloPartitionFunction(numPartitions);
            }
            case Murmur: {
                return new MurmurPartitionFunction(numPartitions);
            }
            case ByteArray: {
                return new ByteArrayPartitionFunction(numPartitions);
            }
        }
        throw new IllegalArgumentException("Illegal partition function name: " + functionName);
    }

    public static enum PartitionFunctionType {
        Modulo,
        Murmur,
        ByteArray;

        private static final Map<String, PartitionFunctionType> VALUE_MAP;

        public static PartitionFunctionType fromString(String name) {
            PartitionFunctionType functionType = VALUE_MAP.get(name.toLowerCase());
            if (functionType == null) {
                throw new IllegalArgumentException("No enum constant for: " + name);
            }
            return functionType;
        }

        static {
            VALUE_MAP = new HashMap<String, PartitionFunctionType>();
            for (PartitionFunctionType functionType : PartitionFunctionType.values()) {
                VALUE_MAP.put(functionType.name().toLowerCase(), functionType);
            }
        }
    }
}

