/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.util.AvroUtils;
import org.apache.pinot.common.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroRecordReader
implements RecordReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroRecordReader.class);
    private final File _dataFile;
    private final org.apache.pinot.common.data.Schema _schema;
    private DataFileStream<GenericRecord> _avroReader;
    private GenericRecord _reusableAvroRecord = null;

    public AvroRecordReader(File dataFile, org.apache.pinot.common.data.Schema schema) throws IOException {
        this._dataFile = dataFile;
        this._schema = schema;
        this._avroReader = AvroUtils.getAvroReader(dataFile);
        try {
            this.validateSchema();
        }
        catch (Exception e) {
            this._avroReader.close();
            throw e;
        }
    }

    private void validateSchema() {
        Schema avroSchema = this._avroReader.getSchema();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            FieldSpec.DataType avroFieldDataType;
            boolean isAvroFieldSingleValue;
            String fieldName = fieldSpec.getName();
            Schema.Field avroField = avroSchema.getField(fieldName);
            if (avroField == null) {
                LOGGER.warn("Pinot field: {} does not exist in Avro Schema", (Object)fieldName);
                continue;
            }
            boolean isPinotFieldSingleValue = fieldSpec.isSingleValueField();
            if (isPinotFieldSingleValue != (isAvroFieldSingleValue = AvroUtils.isSingleValueField(avroField))) {
                String errorMessage = "Pinot field: " + fieldName + " is " + (isPinotFieldSingleValue ? "Single" : "Multi") + "-valued in Pinot schema but not in Avro schema";
                LOGGER.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            FieldSpec.DataType pinotFieldDataType = fieldSpec.getDataType();
            if (pinotFieldDataType == (avroFieldDataType = AvroUtils.extractFieldDataType(avroField))) continue;
            LOGGER.warn("Pinot field: {} of type: {} mismatches with corresponding field in Avro Schema of type: {}", new Object[]{fieldName, pinotFieldDataType, avroFieldDataType});
        }
    }

    @Override
    public boolean hasNext() {
        return this._avroReader.hasNext();
    }

    @Override
    public GenericRow next() throws IOException {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) throws IOException {
        this._reusableAvroRecord = (GenericRecord)this._avroReader.next((Object)this._reusableAvroRecord);
        AvroUtils.fillGenericRow(this._reusableAvroRecord, reuse, this._schema);
        return reuse;
    }

    @Override
    public void rewind() throws IOException {
        this._avroReader.close();
        this._avroReader = AvroUtils.getAvroReader(this._dataFile);
    }

    @Override
    public org.apache.pinot.common.data.Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() throws IOException {
        this._avroReader.close();
    }
}

