/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class MultiplePinotSegmentRecordReader
implements RecordReader {
    private List<PinotSegmentRecordReader> _pinotSegmentRecordReaders;
    private PriorityQueue<GenericRowWithReader> _priorityQueue;
    private Schema _schema;
    private List<String> _sortOrder;
    private int _currentReaderId;

    public MultiplePinotSegmentRecordReader(@Nonnull List<File> indexDirs) throws Exception {
        this(indexDirs, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultiplePinotSegmentRecordReader(@Nonnull List<File> indexDirs, @Nullable Schema schema, @Nullable List<String> sortOrder) throws Exception {
        this._pinotSegmentRecordReaders = new ArrayList<PinotSegmentRecordReader>(indexDirs.size());
        for (File file : indexDirs) {
            this._pinotSegmentRecordReaders.add(new PinotSegmentRecordReader(file, schema, sortOrder));
        }
        if (schema == null) {
            HashSet<Schema> schemas = new HashSet<Schema>();
            for (PinotSegmentRecordReader reader : this._pinotSegmentRecordReaders) {
                schemas.add(reader.getSchema());
            }
            if (schemas.size() != 1) throw new IllegalStateException("Schemas from input segments are not the same");
            this._schema = (Schema)schemas.iterator().next();
        } else {
            this._schema = schema;
        }
        this._sortOrder = sortOrder;
        if (!this.isSortedSegment()) return;
        this._priorityQueue = new PriorityQueue(this._pinotSegmentRecordReaders.size());
        for (PinotSegmentRecordReader pinotSegmentRecordReader : this._pinotSegmentRecordReaders) {
            if (!pinotSegmentRecordReader.hasNext()) continue;
            this._priorityQueue.add(new GenericRowWithReader(pinotSegmentRecordReader.next(), pinotSegmentRecordReader, this._sortOrder, this._schema));
        }
    }

    private boolean isSortedSegment() {
        return this._sortOrder != null && !this._sortOrder.isEmpty();
    }

    @Override
    public boolean hasNext() {
        if (this.isSortedSegment()) {
            return this._priorityQueue.size() > 0;
        }
        boolean hasNext = false;
        for (PinotSegmentRecordReader recordReader : this._pinotSegmentRecordReaders) {
            if (!recordReader.hasNext()) continue;
            hasNext = true;
            break;
        }
        return hasNext;
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        if (this.isSortedSegment()) {
            GenericRowWithReader genericRowComparable = this._priorityQueue.poll();
            GenericRow currentRow = genericRowComparable.getRow();
            reuse.clear();
            for (Map.Entry<String, Object> entry : currentRow.getEntrySet()) {
                reuse.putField(entry.getKey(), entry.getValue());
            }
            PinotSegmentRecordReader recordReader = genericRowComparable.getRecordReader();
            if (recordReader.hasNext()) {
                genericRowComparable.setRow(recordReader.next(currentRow));
                genericRowComparable.setRecordReader(recordReader);
                this._priorityQueue.add(genericRowComparable);
            }
            return reuse;
        }
        for (int i = 0; i < this._pinotSegmentRecordReaders.size(); ++i) {
            PinotSegmentRecordReader currentReader = this._pinotSegmentRecordReaders.get(this._currentReaderId);
            if (currentReader.hasNext()) {
                return currentReader.next(reuse);
            }
            this._currentReaderId = (this._currentReaderId + 1) % this._pinotSegmentRecordReaders.size();
        }
        throw new RuntimeException("next is called after reading all data");
    }

    @Override
    public void rewind() {
        for (PinotSegmentRecordReader recordReader : this._pinotSegmentRecordReaders) {
            recordReader.rewind();
        }
        if (this.isSortedSegment()) {
            this._priorityQueue.clear();
            for (PinotSegmentRecordReader recordReader : this._pinotSegmentRecordReaders) {
                if (!recordReader.hasNext()) continue;
                this._priorityQueue.add(new GenericRowWithReader(recordReader.next(), recordReader, this._sortOrder, this._schema));
            }
        } else {
            this._currentReaderId = 0;
        }
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() {
        for (PinotSegmentRecordReader recordReader : this._pinotSegmentRecordReaders) {
            recordReader.close();
        }
    }

    class GenericRowWithReader
    implements Comparable<GenericRowWithReader> {
        private GenericRow _row;
        private PinotSegmentRecordReader _recordReader;
        private List<String> _sortOrder;
        private Schema _schema;

        public GenericRowWithReader(GenericRow row, PinotSegmentRecordReader recordReader, List<String> sortOrder, Schema schema) {
            this._row = row;
            this._recordReader = recordReader;
            this._sortOrder = sortOrder;
            this._schema = schema;
        }

        @Override
        public int compareTo(GenericRowWithReader o) {
            int compare = 0;
            for (String column : this._sortOrder) {
                block9: {
                    block8: {
                        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
                        Object otherVal = o.getRow().getValue(column);
                        Object thisVal = this._row.getValue(column);
                        if (!fieldSpec.isSingleValueField()) break block8;
                        switch (fieldSpec.getDataType()) {
                            case INT: {
                                compare = ((Integer)thisVal).compareTo((Integer)otherVal);
                                break block9;
                            }
                            case LONG: {
                                compare = ((Long)thisVal).compareTo((Long)otherVal);
                                break block9;
                            }
                            case FLOAT: {
                                compare = ((Float)thisVal).compareTo((Float)otherVal);
                                break block9;
                            }
                            case DOUBLE: {
                                compare = ((Double)thisVal).compareTo((Double)otherVal);
                                break block9;
                            }
                            case STRING: {
                                compare = ((String)thisVal).compareTo((String)otherVal);
                                break block9;
                            }
                            default: {
                                throw new IllegalStateException("Unsupported column value type");
                            }
                        }
                    }
                    throw new IllegalStateException("Multi value column is not supported");
                }
                if (compare == 0) continue;
                return compare;
            }
            return compare;
        }

        public GenericRow getRow() {
            return this._row;
        }

        public void setRow(GenericRow row) {
            this._row = row;
        }

        public PinotSegmentRecordReader getRecordReader() {
            return this._recordReader;
        }

        public void setRecordReader(PinotSegmentRecordReader recordReader) {
            this._recordReader = recordReader;
        }

        public Schema getSchema() {
            return this._schema;
        }

        public void setSchema(Schema schema) {
            this._schema = schema;
        }
    }
}

