/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.ReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;

public class PinotSegmentColumnReader {
    private final Dictionary _dictionary;
    private final DataFileReader _reader;
    private final ReaderContext _readerContext;
    private final int[] _mvBuffer;

    public PinotSegmentColumnReader(ImmutableSegment immutableSegment, String column) {
        this._dictionary = immutableSegment.getDictionary(column);
        this._reader = immutableSegment.getForwardIndex(column);
        this._readerContext = this._reader.createContext();
        SegmentMetadataImpl segmentMetadata = (SegmentMetadataImpl)immutableSegment.getSegmentMetadata();
        ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
        this._mvBuffer = (int[])(columnMetadata.isSingleValue() ? null : new int[columnMetadata.getMaxNumberOfMultiValues()]);
    }

    public Object readInt(int docId) {
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            int dictId = svReader.getInt(docId, this._readerContext);
            return this._dictionary.get(dictId);
        }
        return svReader.getInt(docId, this._readerContext);
    }

    public Object readLong(int docId) {
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            int dictId = svReader.getInt(docId, this._readerContext);
            return this._dictionary.get(dictId);
        }
        return svReader.getLong(docId, this._readerContext);
    }

    public Object readFloat(int docId) {
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            int dictId = svReader.getInt(docId, this._readerContext);
            return this._dictionary.get(dictId);
        }
        return Float.valueOf(svReader.getFloat(docId, this._readerContext));
    }

    public Object readDouble(int docId) {
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            int dictId = svReader.getInt(docId, this._readerContext);
            return this._dictionary.get(dictId);
        }
        return svReader.getDouble(docId, this._readerContext);
    }

    public Object readString(int docId) {
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            int dictId = svReader.getInt(docId, this._readerContext);
            return this._dictionary.get(dictId);
        }
        return svReader.getString(docId, this._readerContext);
    }

    public Object readBytes(int docId) {
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            int dictId = svReader.getInt(docId, this._readerContext);
            return this._dictionary.get(dictId);
        }
        return svReader.getBytes(docId, this._readerContext);
    }

    public Object readSV(int docId, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return this.readInt(docId);
            }
            case LONG: {
                return this.readLong(docId);
            }
            case FLOAT: {
                return this.readFloat(docId);
            }
            case DOUBLE: {
                return this.readDouble(docId);
            }
            case STRING: {
                return this.readString(docId);
            }
            case BYTES: {
                return this.readBytes(docId);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + (Object)((Object)dataType));
    }

    public Object[] readMV(int docId) {
        SingleColumnMultiValueReader mvReader = (SingleColumnMultiValueReader)this._reader;
        int numValues = mvReader.getIntArray(docId, this._mvBuffer, this._readerContext);
        Object[] values = new Object[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = this._dictionary.get(this._mvBuffer[i]);
        }
        return values;
    }

    public int getDictionaryId(int docId) {
        if (this._mvBuffer != null) {
            throw new IllegalStateException("Multi value column is not supported");
        }
        SingleColumnSingleValueReader svReader = (SingleColumnSingleValueReader)this._reader;
        if (this._dictionary != null) {
            return svReader.getInt(docId, this._readerContext);
        }
        throw new IllegalStateException("No dictionary column is not supported");
    }

    public boolean hasDictionary() {
        return this._dictionary != null;
    }
}

