/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentColumnReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.sort.PinotSegmentSorter;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.common.segment.SegmentMetadata;

public class PinotSegmentRecordReader
implements RecordReader {
    private final ImmutableSegment _immutableSegment;
    private final int _numDocs;
    private final Schema _schema;
    private final Map<String, PinotSegmentColumnReader> _columnReaderMap;
    private int _nextDocId = 0;
    private int[] _docIdsInSortedColumnOrder;

    public PinotSegmentRecordReader(@Nonnull File indexDir) throws Exception {
        this(indexDir, null, null);
    }

    public PinotSegmentRecordReader(@Nonnull File indexDir, @Nullable Schema schema, @Nullable List<String> sortOrder) throws Exception {
        this._immutableSegment = ImmutableSegmentLoader.load(indexDir, ReadMode.mmap);
        try {
            SegmentMetadata segmentMetadata = this._immutableSegment.getSegmentMetadata();
            this._numDocs = segmentMetadata.getTotalRawDocs();
            if (schema == null) {
                this._schema = new SegmentMetadataImpl(indexDir).getSchema();
                Set<String> columnNames = this._schema.getColumnNames();
                this._columnReaderMap = new HashMap<String, PinotSegmentColumnReader>(columnNames.size());
                for (String columnName : columnNames) {
                    this._columnReaderMap.put(columnName, new PinotSegmentColumnReader(this._immutableSegment, columnName));
                }
            } else {
                this._schema = schema;
                Schema segmentSchema = segmentMetadata.getSchema();
                Collection<FieldSpec> fieldSpecs = this._schema.getAllFieldSpecs();
                this._columnReaderMap = new HashMap<String, PinotSegmentColumnReader>(fieldSpecs.size());
                for (FieldSpec fieldSpec : fieldSpecs) {
                    String columnName = fieldSpec.getName();
                    FieldSpec segmentFieldSpec = segmentSchema.getFieldSpecFor(columnName);
                    Preconditions.checkState(fieldSpec.equals(segmentFieldSpec), "Field spec mismatch for column: %s, in the given schema: %s, in the segment schema: %s", (Object)columnName, (Object)fieldSpec, (Object)segmentFieldSpec);
                    this._columnReaderMap.put(columnName, new PinotSegmentColumnReader(this._immutableSegment, columnName));
                }
            }
            this.initializeSortedDocIds(this._schema, sortOrder);
        }
        catch (Exception e) {
            this._immutableSegment.destroy();
            throw e;
        }
    }

    private void initializeSortedDocIds(Schema schema, List<String> sortOrder) {
        if (sortOrder != null && !sortOrder.isEmpty()) {
            PinotSegmentSorter sorter = new PinotSegmentSorter(this._numDocs, schema, this._columnReaderMap);
            this._docIdsInSortedColumnOrder = sorter.getSortedDocIds(sortOrder);
        }
    }

    @Override
    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        reuse = this._docIdsInSortedColumnOrder == null ? this.getRecord(reuse, this._nextDocId) : this.getRecord(reuse, this._docIdsInSortedColumnOrder[this._nextDocId]);
        ++this._nextDocId;
        return reuse;
    }

    private GenericRow getRecord(GenericRow reuse, int docId) {
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            String fieldName = fieldSpec.getName();
            if (fieldSpec.isSingleValueField()) {
                reuse.putField(fieldName, this._columnReaderMap.get(fieldName).readSV(docId, fieldSpec.getDataType()));
                continue;
            }
            reuse.putField(fieldName, this._columnReaderMap.get(fieldName).readMV(docId));
        }
        return reuse;
    }

    @Override
    public void rewind() {
        this._nextDocId = 0;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() {
        this._immutableSegment.destroy();
    }
}

