/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.common.data.FieldSpec;

public class RecordReaderUtils {
    private RecordReaderUtils() {
    }

    public static Reader getFileReader(File dataFile) throws IOException {
        return new BufferedReader(new InputStreamReader(RecordReaderUtils.getFileStreamReader(dataFile), "UTF-8"));
    }

    public static InputStream getFileStreamReader(File dataFile) throws IOException {
        InputStream inputStream = dataFile.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(dataFile)) : new FileInputStream(dataFile);
        return inputStream;
    }

    public static BufferedInputStream getFileBufferStream(File dataFile) throws IOException {
        return new BufferedInputStream(RecordReaderUtils.getFileStreamReader(dataFile));
    }

    public static Object convertToDataType(String token, FieldSpec fieldSpec) {
        if (token == null || token.isEmpty()) {
            return fieldSpec.getDefaultNullValue();
        }
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        switch (dataType) {
            case INT: {
                return Integer.parseInt(token);
            }
            case LONG: {
                return Long.parseLong(token);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(token));
            }
            case DOUBLE: {
                return Double.parseDouble(token);
            }
            case STRING: {
                return token;
            }
        }
        throw new IllegalStateException("Illegal data type: " + (Object)((Object)dataType));
    }

    public static Object convertToDataTypeArray(String[] tokens, FieldSpec fieldSpec) {
        Object[] value;
        if (tokens == null || tokens.length == 0) {
            value = new Object[]{fieldSpec.getDefaultNullValue()};
        } else {
            int length = tokens.length;
            value = new Object[length];
            for (int i = 0; i < length; ++i) {
                value[i] = RecordReaderUtils.convertToDataType(tokens[i], fieldSpec);
            }
        }
        return value;
    }

    public static Object convertToDataTypeArray(ArrayList tokens, FieldSpec fieldSpec) {
        Object[] value;
        if (tokens == null || tokens.isEmpty()) {
            value = new Object[]{fieldSpec.getDefaultNullValue()};
        } else {
            int length = tokens.size();
            value = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object token = tokens.get(i);
                value[i] = token == null ? fieldSpec.getDefaultNullValue() : RecordReaderUtils.convertToDataType(token.toString(), fieldSpec);
            }
        }
        return value;
    }

    public static Object convertToDataTypeSet(HashSet tokens, FieldSpec fieldSpec) {
        Object[] value;
        if (tokens == null || tokens.isEmpty()) {
            value = new Object[]{fieldSpec.getDefaultNullValue()};
        } else {
            int length = tokens.size();
            value = new Object[length];
            int index = 0;
            for (Object token : tokens) {
                value[index] = token == null ? fieldSpec.getDefaultNullValue() : RecordReaderUtils.convertToDataType(token.toString(), fieldSpec);
                ++index;
            }
        }
        return value;
    }

    public static void copyRow(GenericRow source, GenericRow destination) {
        destination.clear();
        for (Map.Entry<String, Object> entry : source.getEntrySet()) {
            destination.putField(entry.getKey(), entry.getValue());
        }
    }
}

