/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.DataTypeTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.ExpressionTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.SanitationTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.TimeTransformer;
import org.apache.pinot.common.data.Schema;

public class CompoundTransformer
implements RecordTransformer {
    private final List<RecordTransformer> _transformers;

    public static CompoundTransformer getDefaultTransformer(Schema schema) {
        return new CompoundTransformer(Arrays.asList(new TimeTransformer(schema), new ExpressionTransformer(schema), new DataTypeTransformer(schema), new SanitationTransformer(schema)));
    }

    public static CompoundTransformer getPassThroughTransformer() {
        return new CompoundTransformer(Collections.emptyList());
    }

    public CompoundTransformer(List<RecordTransformer> transformers) {
        this._transformers = transformers;
    }

    @Override
    @Nullable
    public GenericRow transform(GenericRow record) {
        for (RecordTransformer transformer : this._transformers) {
            record = transformer.transform(record);
            if (record != null) continue;
            return null;
        }
        return record;
    }
}

