/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.function.FunctionExpressionEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionTransformer.class);
    private final Map<String, FunctionExpressionEvaluator> _expressionEvaluators = new HashMap<String, FunctionExpressionEvaluator>();

    public ExpressionTransformer(Schema schema) {
        for (Map.Entry<String, FieldSpec> entry : schema.getFieldSpecMap().entrySet()) {
            FieldSpec fieldSpec = entry.getValue();
            String expression = fieldSpec.getTransformFunction();
            if (expression == null) continue;
            try {
                this._expressionEvaluators.put(entry.getKey(), new FunctionExpressionEvaluator(expression));
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while constructing expression evaluator for: {}, skipping", (Object)expression, (Object)e);
            }
        }
    }

    @Override
    @Nullable
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, FunctionExpressionEvaluator> entry : this._expressionEvaluators.entrySet()) {
            String column = entry.getKey();
            if (record.getValue(column) != null) continue;
            record.putField(column, entry.getValue().evaluate(record));
        }
        return record;
    }
}

