/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer;

import org.apache.pinot.common.data.FieldSpec;

public enum PinotDataType {
    BOOLEAN{

        @Override
        public Integer toInteger(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: BOOLEAN to: INTEGER");
        }

        @Override
        public Long toLong(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: BOOLEAN to: LONG");
        }

        @Override
        public Float toFloat(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: BOOLEAN to: FLOAT");
        }

        @Override
        public Double toDouble(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: BOOLEAN to: DOUBLE");
        }
    }
    ,
    BYTE{

        @Override
        public Integer toInteger(Object value) {
            return ((Byte)value).intValue();
        }

        @Override
        public Long toLong(Object value) {
            return ((Byte)value).longValue();
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(((Byte)value).floatValue());
        }

        @Override
        public Double toDouble(Object value) {
            return ((Byte)value).doubleValue();
        }
    }
    ,
    BYTES{}
    ,
    CHARACTER{

        @Override
        public Integer toInteger(Object value) {
            return ((Character)value).charValue();
        }

        @Override
        public Long toLong(Object value) {
            return ((Character)value).charValue();
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(((Character)value).charValue());
        }

        @Override
        public Double toDouble(Object value) {
            return ((Character)value).charValue();
        }
    }
    ,
    SHORT{

        @Override
        public Integer toInteger(Object value) {
            return ((Short)value).intValue();
        }

        @Override
        public Long toLong(Object value) {
            return ((Short)value).longValue();
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(((Short)value).floatValue());
        }

        @Override
        public Double toDouble(Object value) {
            return ((Short)value).doubleValue();
        }
    }
    ,
    INTEGER{

        @Override
        public Integer toInteger(Object value) {
            return (Integer)value;
        }

        @Override
        public Long toLong(Object value) {
            return ((Integer)value).longValue();
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(((Integer)value).floatValue());
        }

        @Override
        public Double toDouble(Object value) {
            return ((Integer)value).doubleValue();
        }

        @Override
        public Integer convert(Object value, PinotDataType sourceType) {
            return sourceType.toInteger(value);
        }
    }
    ,
    LONG{

        @Override
        public Integer toInteger(Object value) {
            return ((Long)value).intValue();
        }

        @Override
        public Long toLong(Object value) {
            return (Long)value;
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(((Long)value).floatValue());
        }

        @Override
        public Double toDouble(Object value) {
            return ((Long)value).doubleValue();
        }

        @Override
        public Long convert(Object value, PinotDataType sourceType) {
            return sourceType.toLong(value);
        }
    }
    ,
    FLOAT{

        @Override
        public Integer toInteger(Object value) {
            return ((Float)value).intValue();
        }

        @Override
        public Long toLong(Object value) {
            return ((Float)value).longValue();
        }

        @Override
        public Float toFloat(Object value) {
            return (Float)value;
        }

        @Override
        public Double toDouble(Object value) {
            return ((Float)value).doubleValue();
        }

        @Override
        public Float convert(Object value, PinotDataType sourceType) {
            return sourceType.toFloat(value);
        }
    }
    ,
    DOUBLE{

        @Override
        public Integer toInteger(Object value) {
            return ((Double)value).intValue();
        }

        @Override
        public Long toLong(Object value) {
            return ((Double)value).longValue();
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(((Double)value).floatValue());
        }

        @Override
        public Double toDouble(Object value) {
            return (Double)value;
        }

        @Override
        public Double convert(Object value, PinotDataType sourceType) {
            return sourceType.toDouble(value);
        }
    }
    ,
    STRING{

        @Override
        public Integer toInteger(Object value) {
            return Integer.parseInt((String)value);
        }

        @Override
        public Long toLong(Object value) {
            return Long.parseLong((String)value);
        }

        @Override
        public Float toFloat(Object value) {
            return Float.valueOf(Float.parseFloat((String)value));
        }

        @Override
        public Double toDouble(Object value) {
            return Double.parseDouble((String)value);
        }

        @Override
        public String convert(Object value, PinotDataType sourceType) {
            return sourceType.toString(value);
        }
    }
    ,
    OBJECT{

        @Override
        public Integer toInteger(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: OBJECT to: INTEGER");
        }

        @Override
        public Long toLong(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: OBJECT to: LONG");
        }

        @Override
        public Float toFloat(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: OBJECT to: FLOAT");
        }

        @Override
        public Double toDouble(Object value) {
            throw new UnsupportedOperationException("Cannot convert value: " + value + " from: OBJECT to: DOUBLE");
        }
    }
    ,
    BYTE_ARRAY,
    CHARACTER_ARRAY,
    SHORT_ARRAY,
    INTEGER_ARRAY{

        public Integer[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toIntegerArray(value);
        }
    }
    ,
    LONG_ARRAY{

        public Long[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toLongArray(value);
        }
    }
    ,
    FLOAT_ARRAY{

        public Float[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toFloatArray(value);
        }
    }
    ,
    DOUBLE_ARRAY{

        public Double[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toDoubleArray(value);
        }
    }
    ,
    STRING_ARRAY{

        public String[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toStringArray(value);
        }
    }
    ,
    OBJECT_ARRAY;


    public Integer toInteger(Object value) {
        return this.getSingleValueType().toInteger(((Object[])value)[0]);
    }

    public Long toLong(Object value) {
        return this.getSingleValueType().toLong(((Object[])value)[0]);
    }

    public Float toFloat(Object value) {
        return this.getSingleValueType().toFloat(((Object[])value)[0]);
    }

    public Double toDouble(Object value) {
        return this.getSingleValueType().toDouble(((Object[])value)[0]);
    }

    public String toString(Object value) {
        if (this.isSingleValue()) {
            return value.toString();
        }
        return ((Object[])value)[0].toString();
    }

    public byte[] toBytes(Object value) {
        throw new UnsupportedOperationException("Cannot convert value: " + value + " form: " + (Object)((Object)this) + " to: BYTES");
    }

    public Integer[] toIntegerArray(Object value) {
        if (this.isSingleValue()) {
            return new Integer[]{this.toInteger(value)};
        }
        Object[] valueArray = (Object[])value;
        int length = valueArray.length;
        Integer[] integerArray = new Integer[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            integerArray[i] = singleValueType.toInteger(valueArray[i]);
        }
        return integerArray;
    }

    public Long[] toLongArray(Object value) {
        if (this.isSingleValue()) {
            return new Long[]{this.toLong(value)};
        }
        Object[] valueArray = (Object[])value;
        int length = valueArray.length;
        Long[] longArray = new Long[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            longArray[i] = singleValueType.toLong(valueArray[i]);
        }
        return longArray;
    }

    public Float[] toFloatArray(Object value) {
        if (this.isSingleValue()) {
            return new Float[]{this.toFloat(value)};
        }
        Object[] valueArray = (Object[])value;
        int length = valueArray.length;
        Float[] floatArray = new Float[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            floatArray[i] = singleValueType.toFloat(valueArray[i]);
        }
        return floatArray;
    }

    public Double[] toDoubleArray(Object value) {
        if (this.isSingleValue()) {
            return new Double[]{this.toDouble(value)};
        }
        Object[] valueArray = (Object[])value;
        int length = valueArray.length;
        Double[] doubleArray = new Double[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            doubleArray[i] = singleValueType.toDouble(valueArray[i]);
        }
        return doubleArray;
    }

    public String[] toStringArray(Object value) {
        if (this.isSingleValue()) {
            return new String[]{this.toString(value)};
        }
        Object[] valueArray = (Object[])value;
        int length = valueArray.length;
        String[] stringArray = new String[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            stringArray[i] = singleValueType.toString(valueArray[i]);
        }
        return stringArray;
    }

    public Object convert(Object value, PinotDataType sourceType) {
        throw new UnsupportedOperationException("Cannot convert value: " + value + " form: " + (Object)((Object)sourceType) + " to: " + (Object)((Object)this));
    }

    public boolean isSingleValue() {
        return this.ordinal() <= OBJECT.ordinal();
    }

    public PinotDataType getSingleValueType() {
        switch (this) {
            case BYTE_ARRAY: {
                return BYTE;
            }
            case CHARACTER_ARRAY: {
                return CHARACTER;
            }
            case SHORT_ARRAY: {
                return SHORT;
            }
            case INTEGER_ARRAY: {
                return INTEGER;
            }
            case LONG_ARRAY: {
                return LONG;
            }
            case FLOAT_ARRAY: {
                return FLOAT;
            }
            case DOUBLE_ARRAY: {
                return DOUBLE;
            }
            case STRING_ARRAY: {
                return STRING;
            }
            case OBJECT_ARRAY: {
                return OBJECT;
            }
        }
        throw new UnsupportedOperationException("Cannot get single-value type for: " + (Object)((Object)this));
    }

    public static PinotDataType getPinotDataType(FieldSpec fieldSpec) {
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        switch (dataType) {
            case INT: {
                return fieldSpec.isSingleValueField() ? INTEGER : INTEGER_ARRAY;
            }
            case LONG: {
                return fieldSpec.isSingleValueField() ? LONG : LONG_ARRAY;
            }
            case FLOAT: {
                return fieldSpec.isSingleValueField() ? FLOAT : FLOAT_ARRAY;
            }
            case DOUBLE: {
                return fieldSpec.isSingleValueField() ? DOUBLE : DOUBLE_ARRAY;
            }
            case STRING: {
                return fieldSpec.isSingleValueField() ? STRING : STRING_ARRAY;
            }
            case BYTES: {
                if (fieldSpec.isSingleValueField()) {
                    return BYTES;
                }
                throw new UnsupportedOperationException("Unsupported multi-valued type: BYTES");
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType) + " in field: " + fieldSpec.getName());
    }
}

