/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.utils.StringUtil;

public class SanitationTransformer
implements RecordTransformer {
    private final Map<String, Integer> _stringColumnMaxLengthMap = new HashMap<String, Integer>();

    public SanitationTransformer(Schema schema) {
        for (Map.Entry<String, FieldSpec> entry : schema.getFieldSpecMap().entrySet()) {
            FieldSpec fieldSpec = entry.getValue();
            if (fieldSpec.getDataType() != FieldSpec.DataType.STRING) continue;
            this._stringColumnMaxLengthMap.put(entry.getKey(), fieldSpec.getMaxLength());
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, Integer> entry : this._stringColumnMaxLengthMap.entrySet()) {
            String stringColumn = entry.getKey();
            int maxLength = entry.getValue();
            Object value = record.getValue(stringColumn);
            if (value instanceof String) {
                String stringValue = (String)value;
                String sanitizedValue = StringUtil.sanitizeStringValue(stringValue, maxLength);
                if (sanitizedValue == stringValue) continue;
                record.putField(stringColumn, sanitizedValue);
                continue;
            }
            Object[] values = (Object[])value;
            int numValues = values.length;
            for (int i = 0; i < numValues; ++i) {
                values[i] = StringUtil.sanitizeStringValue((String)values[i], maxLength);
            }
        }
        return record;
    }
}

