/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer;

import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.TimeFieldSpec;
import org.apache.pinot.common.data.TimeGranularitySpec;
import org.apache.pinot.common.utils.time.TimeConverter;
import org.apache.pinot.common.utils.time.TimeUtils;

public class TimeTransformer
implements RecordTransformer {
    private String _incomingTimeColumn;
    private String _outgoingTimeColumn;
    private TimeConverter _incomingTimeConverter;
    private TimeConverter _outgoingTimeConverter;
    private boolean _isValidated;

    public TimeTransformer(Schema schema) {
        TimeGranularitySpec outgoingGranularitySpec;
        TimeGranularitySpec incomingGranularitySpec;
        TimeFieldSpec timeFieldSpec = schema.getTimeFieldSpec();
        if (timeFieldSpec != null && !(incomingGranularitySpec = timeFieldSpec.getIncomingGranularitySpec()).equals(outgoingGranularitySpec = timeFieldSpec.getOutgoingGranularitySpec())) {
            this._incomingTimeColumn = incomingGranularitySpec.getName();
            this._outgoingTimeColumn = outgoingGranularitySpec.getName();
            this._incomingTimeConverter = new TimeConverter(incomingGranularitySpec);
            this._outgoingTimeConverter = new TimeConverter(outgoingGranularitySpec);
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        if (this._incomingTimeColumn == null) {
            return record;
        }
        Object incomingTimeValue = record.getValue(this._incomingTimeColumn);
        if (!this._isValidated) {
            if (incomingTimeValue == null || !TimeUtils.timeValueInValidRange(this._incomingTimeConverter.toMillisSinceEpoch(incomingTimeValue))) {
                Object outgoingTimeValue = record.getValue(this._outgoingTimeColumn);
                if (outgoingTimeValue == null || !TimeUtils.timeValueInValidRange(this._outgoingTimeConverter.toMillisSinceEpoch(outgoingTimeValue))) {
                    throw new IllegalStateException("No valid time value found in either incoming time column: " + this._incomingTimeColumn + " or outgoing time column: " + this._outgoingTimeColumn);
                }
                this.disableConversion();
                return record;
            }
            this._isValidated = true;
        }
        record.putField(this._outgoingTimeColumn, this._outgoingTimeConverter.fromMillisSinceEpoch(this._incomingTimeConverter.toMillisSinceEpoch(incomingTimeValue)));
        return record;
    }

    private void disableConversion() {
        this._incomingTimeColumn = null;
        this._outgoingTimeColumn = null;
        this._incomingTimeConverter = null;
        this._outgoingTimeConverter = null;
    }
}

