/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegmentUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleColumnMultiValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleColumnSingleValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.MutableDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.MutableDictionaryFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.invertedindex.RealtimeInvertedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source.ColumnDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.$internal.org.apache.pinot.core.util.FixedIntArray;
import org.apache.pinot.$internal.org.apache.pinot.core.util.FixedIntArrayOffHeapIdMap;
import org.apache.pinot.$internal.org.apache.pinot.core.util.IdMap;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.segment.SegmentMetadata;
import org.apache.pinot.common.utils.NetUtil;
import org.roaringbitmap.IntIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableSegmentImpl
implements MutableSegment {
    private static final int MAX_MULTI_VALUES_PER_ROW = 1000;
    private static final String RECORD_ID_MAP = "__recordIdMap__";
    private static final int EXPECTED_COMPRESSION = 1000;
    private static final int MIN_ROWS_TO_INDEX = 1000000;
    private static final int MIN_RECORD_ID_MAP_CACHE_SIZE = 10000;
    private final Logger _logger;
    private final long _startTimeMillis = System.currentTimeMillis();
    private final String _segmentName;
    private final Schema _schema;
    private final int _capacity;
    private final SegmentMetadata _segmentMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final SegmentPartitionConfig _segmentPartitionConfig;
    private final Map<String, MutableDictionary> _dictionaryMap = new HashMap<String, MutableDictionary>();
    private final Map<String, DataFileReader> _indexReaderWriterMap = new HashMap<String, DataFileReader>();
    private final Map<String, Integer> _maxNumValuesMap = new HashMap<String, Integer>();
    private final Map<String, RealtimeInvertedIndexReader> _invertedIndexMap = new HashMap<String, RealtimeInvertedIndexReader>();
    private final Map<String, .BloomFilterReader> _bloomFilterMap = new HashMap<String, .BloomFilterReader>();
    private final IdMap<FixedIntArray> _recordIdMap;
    private boolean _aggregateMetrics;
    private volatile int _numDocsIndexed = 0;
    private volatile long _minTime = Long.MAX_VALUE;
    private volatile long _maxTime = Long.MIN_VALUE;
    private final int _numKeyColumns;

    public MutableSegmentImpl(RealtimeSegmentConfig config) {
        this._segmentName = config.getSegmentName();
        this._schema = config.getSchema();
        this._capacity = config.getCapacity();
        this._segmentMetadata = new SegmentMetadataImpl(config.getRealtimeSegmentZKMetadata(), this._schema){

            @Override
            public int getTotalDocs() {
                return MutableSegmentImpl.this._numDocsIndexed;
            }

            @Override
            public int getTotalRawDocs() {
                return MutableSegmentImpl.this._numDocsIndexed;
            }
        };
        this._offHeap = config.isOffHeap();
        this._memoryManager = config.getMemoryManager();
        this._statsHistory = config.getStatsHistory();
        this._segmentPartitionConfig = config.getSegmentPartitionConfig();
        this._numKeyColumns = this._schema.getDimensionNames().size() + 1;
        this._logger = LoggerFactory.getLogger((String)(MutableSegmentImpl.class.getName() + "_" + this._segmentName + "_" + config.getStreamName()));
        Set<String> noDictionaryColumns = config.getNoDictionaryColumns();
        Set<String> invertedIndexColumns = config.getInvertedIndexColumns();
        int avgNumMultiValues = config.getAvgNumMultiValues();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            DataFileReader indexReaderWriter;
            String allocationContext;
            String column = fieldSpec.getName();
            this._maxNumValuesMap.put(column, 0);
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            int indexColumnSize = FieldSpec.DataType.INT.size();
            if (noDictionaryColumns.contains(column) && fieldSpec.isSingleValueField() && dataType != FieldSpec.DataType.STRING && !invertedIndexColumns.contains(column)) {
                indexColumnSize = dataType.size();
            } else {
                int dictionaryColumnSize = dataType == FieldSpec.DataType.STRING ? this._statsHistory.getEstimatedAvgColSize(column) : dataType.size();
                allocationContext = this.buildAllocationContext(this._segmentName, column, ".dict");
                MutableDictionary dictionary = MutableDictionaryFactory.getMutableDictionary(dataType, this._offHeap, this._memoryManager, dictionaryColumnSize, Math.min(this._statsHistory.getEstimatedCardinality(column), this._capacity), allocationContext);
                this._dictionaryMap.put(column, dictionary);
                noDictionaryColumns.remove(column);
            }
            if (fieldSpec.isSingleValueField()) {
                allocationContext = this.buildAllocationContext(this._segmentName, column, ".sv.unsorted.fwd");
                indexReaderWriter = new FixedByteSingleColumnSingleValueReaderWriter(this._capacity, indexColumnSize, this._memoryManager, allocationContext);
            } else {
                allocationContext = this.buildAllocationContext(this._segmentName, column, ".mv.fwd");
                indexReaderWriter = new FixedByteSingleColumnMultiValueReaderWriter(1000, avgNumMultiValues, this._capacity, indexColumnSize, this._memoryManager, allocationContext);
            }
            this._indexReaderWriterMap.put(column, indexReaderWriter);
            if (!invertedIndexColumns.contains(column)) continue;
            this._invertedIndexMap.put(column, new RealtimeInvertedIndexReader());
        }
        this._recordIdMap = this.enableMetricsAggregationIfPossible(config, this._schema, noDictionaryColumns);
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        return this._segmentPartitionConfig;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    @Override
    public boolean index(GenericRow row) {
        Map<String, Object> dictIdMap = this.updateDictionary(row);
        int numDocs = this._numDocsIndexed;
        int docId = this.getOrCreateDocId(dictIdMap);
        if (docId == numDocs) {
            this.addForwardIndex(row, docId, dictIdMap);
            this.addInvertedIndex(docId, dictIdMap);
            return this._numDocsIndexed++ < this._capacity;
        }
        Preconditions.checkState(this._aggregateMetrics, "Invalid document-id during indexing: " + docId + " expected: " + numDocs);
        return this.aggregateMetrics(row, docId);
    }

    private Map<String, Object> updateDictionary(GenericRow row) {
        HashMap<String, Object> dictIdMap = new HashMap<String, Object>();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            String column = fieldSpec.getName();
            Object value = row.getValue(column);
            MutableDictionary dictionary = this._dictionaryMap.get(column);
            if (dictionary != null) {
                dictionary.index(value);
            }
            if (fieldSpec.isSingleValueField()) {
                if (dictionary != null) {
                    dictIdMap.put(column, dictionary.indexOf(value));
                }
            } else {
                int i = 0;
                Object[] values = (Object[])value;
                int[] dictIds = new int[values.length];
                for (Object object : values) {
                    dictIds[i++] = dictionary.indexOf(object);
                }
                dictIdMap.put(column, dictIds);
                int numValues = ((Object[])value).length;
                if (this._maxNumValuesMap.get(column) >= numValues) continue;
                this._maxNumValuesMap.put(column, numValues);
                continue;
            }
            if (!fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.TIME)) continue;
            long timeValue = value instanceof Number ? ((Number)value).longValue() : Long.valueOf(value.toString()).longValue();
            this._minTime = Math.min(this._minTime, timeValue);
            this._maxTime = Math.max(this._maxTime, timeValue);
        }
        return dictIdMap;
    }

    private void addForwardIndex(GenericRow row, int docId, Map<String, Object> dictIdMap) {
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            String column = fieldSpec.getName();
            Object value = row.getValue(column);
            if (fieldSpec.isSingleValueField()) {
                FixedByteSingleColumnSingleValueReaderWriter indexReaderWriter = (FixedByteSingleColumnSingleValueReaderWriter)this._indexReaderWriterMap.get(column);
                Integer dictId = (Integer)dictIdMap.get(column);
                if (dictId != null) {
                    indexReaderWriter.setInt(docId, dictId);
                    continue;
                }
                FieldSpec.DataType dataType = fieldSpec.getDataType();
                switch (dataType) {
                    case INT: {
                        indexReaderWriter.setInt(docId, (Integer)value);
                        break;
                    }
                    case LONG: {
                        indexReaderWriter.setLong(docId, (Long)value);
                        break;
                    }
                    case FLOAT: {
                        indexReaderWriter.setFloat(docId, ((Float)value).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        indexReaderWriter.setDouble(docId, (Double)value);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType) + " for no-dictionary column: " + column);
                    }
                }
                continue;
            }
            int[] dictIds = (int[])dictIdMap.get(column);
            ((FixedByteSingleColumnMultiValueReaderWriter)this._indexReaderWriterMap.get(column)).setIntArray(docId, dictIds);
        }
    }

    private void addInvertedIndex(int docId, Map<String, Object> dictIdMap) {
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            int[] dictIds;
            String column = fieldSpec.getName();
            RealtimeInvertedIndexReader invertedIndex = this._invertedIndexMap.get(column);
            if (invertedIndex == null) continue;
            if (fieldSpec.isSingleValueField()) {
                invertedIndex.add((Integer)dictIdMap.get(column), docId);
                continue;
            }
            for (int dictId : dictIds = (int[])dictIdMap.get(column)) {
                invertedIndex.add(dictId, docId);
            }
        }
    }

    private boolean aggregateMetrics(GenericRow row, int docId) {
        block6: for (FieldSpec fieldSpec : this._schema.getMetricFieldSpecs()) {
            String column = fieldSpec.getName();
            Object value = row.getValue(column);
            Preconditions.checkState(fieldSpec.isSingleValueField(), "Multivalued metrics cannot be updated.");
            FixedByteSingleColumnSingleValueReaderWriter indexReaderWriter = (FixedByteSingleColumnSingleValueReaderWriter)this._indexReaderWriterMap.get(column);
            Preconditions.checkState(this._dictionaryMap.get(column) == null, "Updating metrics not supported with dictionary.");
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            switch (dataType) {
                case INT: {
                    indexReaderWriter.setInt(docId, (Integer)value + indexReaderWriter.getInt(docId));
                    continue block6;
                }
                case LONG: {
                    indexReaderWriter.setLong(docId, (Long)value + indexReaderWriter.getLong(docId));
                    continue block6;
                }
                case FLOAT: {
                    indexReaderWriter.setFloat(docId, indexReaderWriter.getFloat(docId) + indexReaderWriter.getFloat(docId));
                    continue block6;
                }
                case DOUBLE: {
                    indexReaderWriter.setDouble(docId, indexReaderWriter.getDouble(docId) + indexReaderWriter.getDouble(docId));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType) + " for no-dictionary column: " + column);
        }
        return true;
    }

    @Override
    public int getNumDocsIndexed() {
        return this._numDocsIndexed;
    }

    @Override
    public String getSegmentName() {
        return this._segmentName;
    }

    @Override
    public SegmentMetadata getSegmentMetadata() {
        return this._segmentMetadata;
    }

    @Override
    public Set<String> getColumnNames() {
        return this._schema.getColumnNames();
    }

    @Override
    public Set<String> getPhysicalColumnNames() {
        HashSet<String> physicalColumnNames = new HashSet<String>();
        for (String columnName : this.getColumnNames()) {
            if (this._segmentMetadata.getSchema().isVirtualColumn(columnName)) continue;
            physicalColumnNames.add(columnName);
        }
        return physicalColumnNames;
    }

    @Override
    public ColumnDataSource getDataSource(String columnName) {
        if (!this._schema.isVirtualColumn(columnName)) {
            return new ColumnDataSource(this._schema.getFieldSpecFor(columnName), this._numDocsIndexed, this._maxNumValuesMap.get(columnName), this._indexReaderWriterMap.get(columnName), this._invertedIndexMap.get(columnName), this._dictionaryMap.get(columnName), this._bloomFilterMap.get(columnName));
        }
        return this.getVirtualDataSource(columnName);
    }

    private ColumnDataSource getVirtualDataSource(String column) {
        VirtualColumnContext virtualColumnContext = new VirtualColumnContext(NetUtil.getHostnameOrAddress(), this._segmentMetadata.getTableName(), this.getSegmentName(), column, this._numDocsIndexed + 1);
        VirtualColumnProvider provider = VirtualColumnProviderFactory.buildProvider(this._schema.getFieldSpecFor(column).getVirtualColumnProvider());
        return new ColumnDataSource(provider.buildColumnIndexContainer(virtualColumnContext), provider.buildMetadata(virtualColumnContext));
    }

    @Override
    public List<StarTreeV2> getStarTrees() {
        return null;
    }

    @Override
    public GenericRow getRecord(int docId, GenericRow reuse) {
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            String column = fieldSpec.getName();
            reuse.putField(column, IndexSegmentUtils.getValue(docId, fieldSpec, this._indexReaderWriterMap.get(column), this._dictionaryMap.get(column), this._maxNumValuesMap.getOrDefault(column, 0)));
        }
        return reuse;
    }

    @Override
    public void destroy() {
        this._logger.info("Trying to close RealtimeSegmentImpl : {}", (Object)this._segmentName);
        if (this._offHeap && this._numDocsIndexed > 0) {
            int numSeconds = (int)((System.currentTimeMillis() - this._startTimeMillis) / 1000L);
            long totalMemBytes = this._memoryManager.getTotalAllocatedBytes();
            this._logger.info("Segment used {} bytes of memory for {} rows consumed in {} seconds", new Object[]{totalMemBytes, this._numDocsIndexed, numSeconds});
            RealtimeSegmentStatsHistory.SegmentStats segmentStats = new RealtimeSegmentStatsHistory.SegmentStats();
            for (Map.Entry<String, MutableDictionary> entry : this._dictionaryMap.entrySet()) {
                RealtimeSegmentStatsHistory.ColumnStats columnStats = new RealtimeSegmentStatsHistory.ColumnStats();
                columnStats.setCardinality(entry.getValue().length());
                columnStats.setAvgColumnSize(entry.getValue().getAvgValueSize());
                segmentStats.setColumnStats(entry.getKey(), columnStats);
            }
            segmentStats.setNumRowsConsumed(this._numDocsIndexed);
            segmentStats.setNumRowsIndexed(this._numDocsIndexed);
            segmentStats.setMemUsedBytes(totalMemBytes);
            segmentStats.setNumSeconds(numSeconds);
            this._statsHistory.addSegmentStats(segmentStats);
        }
        for (DataFileReader dataFileReader : this._indexReaderWriterMap.values()) {
            try {
                dataFileReader.close();
            }
            catch (IOException e) {
                this._logger.error("Failed to close index. Service will continue with potential memory leak, error: ", (Throwable)e);
            }
        }
        this._indexReaderWriterMap.clear();
        for (RealtimeInvertedIndexReader realtimeInvertedIndexReader : this._invertedIndexMap.values()) {
            realtimeInvertedIndexReader.close();
        }
        for (Map.Entry entry : this._dictionaryMap.entrySet()) {
            try {
                ((MutableDictionary)entry.getValue()).close();
            }
            catch (IOException e) {
                this._logger.error("Could not close dictionary for column {}", entry.getKey());
            }
        }
        this._invertedIndexMap.clear();
        this._segmentMetadata.close();
        try {
            this._memoryManager.close();
        }
        catch (IOException e) {
            this._logger.error("Could not close memory manager", (Throwable)e);
        }
        if (this._recordIdMap != null) {
            this._recordIdMap.clear();
        }
    }

    private IntIterator[] getSortedBitmapIntIteratorsForIntColumn(String column) {
        MutableDictionary dictionary = this._dictionaryMap.get(column);
        int numValues = dictionary.length();
        IntIterator[] intIterators = new IntIterator[numValues];
        RealtimeInvertedIndexReader invertedIndex = this._invertedIndexMap.get(column);
        int[] values = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = (Integer)dictionary.get(i);
        }
        long start = System.currentTimeMillis();
        Arrays.sort(values);
        this._logger.info("Spent {}ms sorting int column: {} with cardinality: {}", new Object[]{System.currentTimeMillis() - start, column, numValues});
        for (int i = 0; i < numValues; ++i) {
            intIterators[i] = invertedIndex.getDocIds(dictionary.indexOf(values[i])).getIntIterator();
        }
        return intIterators;
    }

    private IntIterator[] getSortedBitmapIntIteratorsForLongColumn(String column) {
        MutableDictionary dictionary = this._dictionaryMap.get(column);
        int numValues = dictionary.length();
        IntIterator[] intIterators = new IntIterator[numValues];
        RealtimeInvertedIndexReader invertedIndex = this._invertedIndexMap.get(column);
        long[] values = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = (Long)dictionary.get(i);
        }
        long start = System.currentTimeMillis();
        Arrays.sort(values);
        this._logger.info("Spent {}ms sorting long column: {} with cardinality: {}", new Object[]{System.currentTimeMillis() - start, column, numValues});
        for (int i = 0; i < numValues; ++i) {
            intIterators[i] = invertedIndex.getDocIds(dictionary.indexOf(values[i])).getIntIterator();
        }
        return intIterators;
    }

    private IntIterator[] getSortedBitmapIntIteratorsForFloatColumn(String column) {
        MutableDictionary dictionary = this._dictionaryMap.get(column);
        int numValues = dictionary.length();
        IntIterator[] intIterators = new IntIterator[numValues];
        RealtimeInvertedIndexReader invertedIndex = this._invertedIndexMap.get(column);
        float[] values = new float[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = ((Float)dictionary.get(i)).floatValue();
        }
        long start = System.currentTimeMillis();
        Arrays.sort(values);
        this._logger.info("Spent {}ms sorting float column: {} with cardinality: {}", new Object[]{System.currentTimeMillis() - start, column, numValues});
        for (int i = 0; i < numValues; ++i) {
            intIterators[i] = invertedIndex.getDocIds(dictionary.indexOf(Float.valueOf(values[i]))).getIntIterator();
        }
        return intIterators;
    }

    private IntIterator[] getSortedBitmapIntIteratorsForDoubleColumn(String column) {
        MutableDictionary dictionary = this._dictionaryMap.get(column);
        int numValues = dictionary.length();
        IntIterator[] intIterators = new IntIterator[numValues];
        RealtimeInvertedIndexReader invertedIndex = this._invertedIndexMap.get(column);
        double[] values = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = (Double)dictionary.get(i);
        }
        long start = System.currentTimeMillis();
        Arrays.sort(values);
        this._logger.info("Spent {}ms sorting double column: {} with cardinality: {}", new Object[]{System.currentTimeMillis() - start, column, numValues});
        for (int i = 0; i < numValues; ++i) {
            intIterators[i] = invertedIndex.getDocIds(dictionary.indexOf(values[i])).getIntIterator();
        }
        return intIterators;
    }

    private IntIterator[] getSortedBitmapIntIteratorsForStringColumn(String column) {
        MutableDictionary dictionary = this._dictionaryMap.get(column);
        int numValues = dictionary.length();
        IntIterator[] intIterators = new IntIterator[numValues];
        RealtimeInvertedIndexReader invertedIndex = this._invertedIndexMap.get(column);
        Object[] values = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = (String)dictionary.get(i);
        }
        long start = System.currentTimeMillis();
        Arrays.sort(values);
        this._logger.info("Spent {}ms sorting string column: {} with cardinality: {}", new Object[]{System.currentTimeMillis() - start, column, numValues});
        for (int i = 0; i < numValues; ++i) {
            intIterators[i] = invertedIndex.getDocIds(dictionary.indexOf(values[i])).getIntIterator();
        }
        return intIterators;
    }

    public int[] getSortedDocIdIterationOrderWithSortedColumn(String column) {
        IntIterator[] iterators;
        int[] docIds = new int[this._numDocsIndexed];
        FieldSpec.DataType dataType = this._schema.getFieldSpecFor(column).getDataType();
        switch (dataType) {
            case INT: {
                iterators = this.getSortedBitmapIntIteratorsForIntColumn(column);
                break;
            }
            case LONG: {
                iterators = this.getSortedBitmapIntIteratorsForLongColumn(column);
                break;
            }
            case FLOAT: {
                iterators = this.getSortedBitmapIntIteratorsForFloatColumn(column);
                break;
            }
            case DOUBLE: {
                iterators = this.getSortedBitmapIntIteratorsForDoubleColumn(column);
                break;
            }
            case STRING: {
                iterators = this.getSortedBitmapIntIteratorsForStringColumn(column);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType) + " for sorted column: " + column);
            }
        }
        int i = 0;
        for (IntIterator iterator : iterators) {
            while (iterator.hasNext()) {
                docIds[i++] = iterator.next();
            }
        }
        Preconditions.checkState(this._numDocsIndexed == i, "The number of docs indexed: %s is not equal to the number of sorted documents: %s", this._numDocsIndexed, i);
        return docIds;
    }

    private String buildAllocationContext(String segmentName, String columnName, String indexType) {
        return segmentName + ":" + columnName + indexType;
    }

    private int getOrCreateDocId(Map<String, Object> dictIdMap) {
        if (!this._aggregateMetrics) {
            return this._numDocsIndexed;
        }
        int i = 0;
        int[] dictIds = new int[this._numKeyColumns];
        for (String column : this._schema.getDimensionNames()) {
            dictIds[i++] = (Integer)dictIdMap.get(column);
        }
        String timeColumnName = this._schema.getTimeColumnName();
        if (timeColumnName != null) {
            dictIds[i] = (Integer)dictIdMap.get(timeColumnName);
        }
        return this._recordIdMap.put(new FixedIntArray(dictIds));
    }

    private IdMap<FixedIntArray> enableMetricsAggregationIfPossible(RealtimeSegmentConfig config, Schema schema, Set<String> noDictionaryColumns) {
        String timeColumn;
        this._aggregateMetrics = config.aggregateMetrics();
        if (!this._aggregateMetrics) {
            this._logger.info("Metrics aggregation is disabled.");
            return null;
        }
        for (String metric : schema.getMetricNames()) {
            if (noDictionaryColumns.contains(metric)) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of dictionary encoded metrics, eg: {}", (Object)metric);
            this._aggregateMetrics = false;
            break;
        }
        for (String dimension : schema.getDimensionNames()) {
            if (!noDictionaryColumns.contains(dimension)) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary dimensions, eg: {}", (Object)dimension);
            this._aggregateMetrics = false;
            break;
        }
        if (noDictionaryColumns.contains(timeColumn = schema.getTimeColumnName())) {
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary time column, eg: {}", (Object)timeColumn);
            this._aggregateMetrics = false;
        }
        if (!this._aggregateMetrics) {
            return null;
        }
        int estimatedRowsToIndex = this._statsHistory.isEmpty() ? Math.max(config.getCapacity() / 1000, 1000000) : Math.max(this._statsHistory.getEstimatedRowsToIndex(), 1000000);
        int maxOverFlowHashSize = Math.max(estimatedRowsToIndex / 1000, 10000);
        this._logger.info("Initializing metrics update: estimatedRowsToIndex:{}, cacheSize:{}", (Object)estimatedRowsToIndex, (Object)maxOverFlowHashSize);
        return new FixedIntArrayOffHeapIdMap(estimatedRowsToIndex, maxOverFlowHashSize, this._numKeyColumns, this._memoryManager, RECORD_ID_MAP);
    }
}

