/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1;

import java.io.IOException;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.BaseSingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.ReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.SortedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.Pairs;

public class SortedIndexReaderImpl
extends BaseSingleColumnSingleValueReader<Context>
implements SortedIndexReader<Context> {
    private final FixedByteValueReaderWriter _reader;
    private final int _cardinality;

    public SortedIndexReaderImpl(PinotDataBuffer dataBuffer, int cardinality) {
        Preconditions.checkState(dataBuffer.size() == (long)(2 * cardinality * 4));
        this._reader = new FixedByteValueReaderWriter(dataBuffer);
        this._cardinality = cardinality;
    }

    @Override
    public int getInt(int row) {
        if (this._cardinality == 1) {
            return 0;
        }
        return this.binarySearch(row, 0, this._cardinality - 1);
    }

    @Override
    public int getInt(int row, Context context) {
        if (this._cardinality == 1) {
            return 0;
        }
        int contextDictId = context._dictId;
        int contextStartOffset = context._startOffset;
        int contextEndOffset = context._endOffset;
        if (row >= contextStartOffset) {
            if (row <= contextEndOffset) {
                return contextDictId;
            }
            int nextDictId = contextDictId + 1;
            int nextEndOffset = this._reader.getInt(2 * nextDictId + 1);
            if (row <= nextEndOffset) {
                context._dictId = nextDictId;
                context._startOffset = contextEndOffset + 1;
                context._endOffset = nextEndOffset;
                return nextDictId;
            }
        }
        int dictId = row < contextStartOffset ? this.binarySearch(row, 0, contextDictId - 1) : this.binarySearch(row, contextDictId + 2, this._cardinality - 1);
        context._dictId = dictId;
        context._startOffset = this._reader.getInt(2 * dictId);
        context._endOffset = this._reader.getInt(2 * dictId + 1);
        return dictId;
    }

    private int binarySearch(int row, int low, int high) {
        while (low <= high) {
            int mid = (low + high) / 2;
            if (this._reader.getInt(2 * mid) <= row) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return high;
    }

    @Override
    public void readValues(int[] rows, int rowsStartIndex, int rowSize, int[] values, int valuesStartIndex) {
        int rowsEndIndex = rowsStartIndex + rowSize;
        if (this._cardinality == 1) {
            for (int i = rowsStartIndex; i < rowsEndIndex; ++i) {
                values[valuesStartIndex++] = 0;
            }
        } else {
            Context context = new Context();
            for (int i = rowsStartIndex; i < rowsEndIndex; ++i) {
                values[valuesStartIndex++] = this.getInt(rows[i], context);
            }
        }
    }

    @Override
    public Context createContext() {
        return new Context();
    }

    @Override
    public Pairs.IntPair getDocIds(int dictId) {
        return new Pairs.IntPair(this._reader.getInt(2 * dictId), this._reader.getInt(2 * dictId + 1));
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }

    public static class Context
    implements ReaderContext {
        public int _dictId = -1;
        public int _startOffset = -1;
        public int _endOffset = -1;
    }
}

