/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.HLCSegmentName;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.SegmentName;

public abstract class RealtimeIndexOffHeapMemoryManager
implements PinotDataBufferMemoryManager {
    private final List<PinotDataBuffer> _buffers = new LinkedList<PinotDataBuffer>();
    private final String _segmentName;
    private final ServerMetrics _serverMetrics;
    private long _totalAllocatedBytes = 0L;
    private final String _tableName;

    protected RealtimeIndexOffHeapMemoryManager(ServerMetrics serverMetrics, String segmentName) {
        this._serverMetrics = serverMetrics;
        this._segmentName = segmentName;
        if (SegmentName.isLowLevelConsumerSegmentName(segmentName)) {
            LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
            this._tableName = llcSegmentName.getTableName();
        } else if (SegmentName.isHighLevelConsumerSegmentName(segmentName)) {
            HLCSegmentName hlcSegmentName = new HLCSegmentName(segmentName);
            this._tableName = hlcSegmentName.getTableName();
        } else {
            this._tableName = "NoSuchTable";
        }
    }

    @Override
    public PinotDataBuffer allocate(long size, String allocationContext) {
        Preconditions.checkArgument(size > 0L, "Illegal memory allocation " + size + " for segment " + this._segmentName + " column " + allocationContext);
        PinotDataBuffer buffer = this.allocateInternal(size, allocationContext);
        this._totalAllocatedBytes += size;
        this._buffers.add(buffer);
        this._serverMetrics.addValueToTableGauge(this._tableName, ServerGauge.REALTIME_OFFHEAP_MEMORY_USED, size);
        return buffer;
    }

    protected abstract void doClose() throws IOException;

    protected abstract PinotDataBuffer allocateInternal(long var1, String var3);

    @Override
    public void close() throws IOException {
        for (PinotDataBuffer buffer : this._buffers) {
            buffer.close();
        }
        this._serverMetrics.addValueToTableGauge(this._tableName, ServerGauge.REALTIME_OFFHEAP_MEMORY_USED, -this._totalAllocatedBytes);
        this.doClose();
        this._buffers.clear();
        this._totalAllocatedBytes = 0L;
    }

    @Override
    public long getTotalAllocatedBytes() {
        return this._totalAllocatedBytes;
    }
}

