/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.FixedByteSingleValueMultiColReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.BaseSingleColumnMultiValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedByteSingleColumnMultiValueReaderWriter
extends BaseSingleColumnMultiValueReaderWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedByteSingleColumnMultiValueReaderWriter.class);
    private static final int SIZE_OF_INT = 4;
    private static final int NUM_COLS_IN_HEADER = 3;
    private static final int INCREMENT_PERCENTAGE = 100;
    private PinotDataBuffer _headerBuffer;
    private List<PinotDataBuffer> _dataBuffers = new ArrayList<PinotDataBuffer>();
    private List<PinotDataBuffer> _headerBuffers = new ArrayList<PinotDataBuffer>();
    private List<FixedByteSingleValueMultiColReader> _headerReaders = new ArrayList<FixedByteSingleValueMultiColReader>();
    private List<FixedByteSingleValueMultiColWriter> _headerWriters = new ArrayList<FixedByteSingleValueMultiColWriter>();
    private FixedByteSingleValueMultiColWriter _curHeaderWriter;
    private List<FixedByteSingleValueMultiColWriter> _dataWriters = new ArrayList<FixedByteSingleValueMultiColWriter>();
    private List<FixedByteSingleValueMultiColReader> _dataReaders = new ArrayList<FixedByteSingleValueMultiColReader>();
    private FixedByteSingleValueMultiColWriter _currentDataWriter;
    private int _currentDataWriterIndex = -1;
    private int _currentCapacity = 0;
    private int _headerSize;
    private int _incrementalCapacity;
    private int _columnSizeInBytes;
    private int _maxNumberOfMultiValuesPerRow;
    private final int _rowCountPerChunk;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _context;
    private int _prevRowStartIndex = 0;
    private int _prevRowLength = 0;

    public FixedByteSingleColumnMultiValueReaderWriter(int maxNumberOfMultiValuesPerRow, int avgMultiValueCount, int rowCountPerChunk, int columnSizeInBytes, PinotDataBufferMemoryManager memoryManager, String context) {
        this._memoryManager = memoryManager;
        this._context = context;
        int initialCapacity = Math.max(maxNumberOfMultiValuesPerRow, rowCountPerChunk * avgMultiValueCount);
        int incrementalCapacity = Math.max(maxNumberOfMultiValuesPerRow, (int)((float)initialCapacity * 1.0f * 100.0f / 100.0f));
        this._columnSizeInBytes = columnSizeInBytes;
        this._maxNumberOfMultiValuesPerRow = maxNumberOfMultiValuesPerRow;
        this._headerSize = rowCountPerChunk * 4 * 3;
        this._rowCountPerChunk = rowCountPerChunk;
        this.addHeaderBuffers();
        this._incrementalCapacity = incrementalCapacity;
        this.addDataBuffers(initialCapacity);
    }

    private void addHeaderBuffers() {
        LOGGER.info("Allocating header buffer of size {} for: {}", (Object)this._headerSize, (Object)this._context);
        this._headerBuffer = this._memoryManager.allocate(this._headerSize, this._context);
        this._curHeaderWriter = new FixedByteSingleValueMultiColWriter(this._headerBuffer, 3, new int[]{4, 4, 4});
        FixedByteSingleValueMultiColReader curHeaderReader = new FixedByteSingleValueMultiColReader(this._headerBuffer, this._rowCountPerChunk, new int[]{4, 4, 4});
        this._headerBuffers.add(this._headerBuffer);
        this._headerWriters.add(this._curHeaderWriter);
        this._headerReaders.add(curHeaderReader);
    }

    private void addDataBuffers(int rowCapacity) {
        try {
            long size = rowCapacity * this._columnSizeInBytes;
            LOGGER.info("Allocating data buffer of size {} for column {}", (Object)size, (Object)this._context);
            PinotDataBuffer dataBuffer = this._memoryManager.allocate(size, this._context);
            this._dataBuffers.add(dataBuffer);
            this._currentDataWriter = new FixedByteSingleValueMultiColWriter(dataBuffer, 1, new int[]{this._columnSizeInBytes});
            this._dataWriters.add(this._currentDataWriter);
            FixedByteSingleValueMultiColReader dataFileReader = new FixedByteSingleValueMultiColReader(dataBuffer, rowCapacity, new int[]{this._columnSizeInBytes});
            this._dataReaders.add(dataFileReader);
            this._currentCapacity = rowCapacity;
            ++this._currentDataWriterIndex;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while expanding the capacity by allocating additional buffer with capacity:" + rowCapacity, e);
        }
    }

    @Override
    public void close() throws IOException {
        for (PinotDataBuffer dataBuffer : this._dataBuffers) {
            dataBuffer.close();
        }
        this._dataBuffers.clear();
        for (PinotDataBuffer headerBuffer : this._headerBuffers) {
            headerBuffer.close();
        }
        this._headerBuffers.clear();
        this._headerBuffer = null;
        for (FixedByteSingleValueMultiColReader reader : this._headerReaders) {
            reader.close();
        }
        for (FixedByteSingleValueMultiColReader reader : this._dataReaders) {
            reader.close();
        }
        for (FixedByteSingleValueMultiColWriter writer : this._headerWriters) {
            writer.close();
        }
        for (FixedByteSingleValueMultiColWriter writer : this._dataWriters) {
            writer.close();
        }
    }

    private void writeIntoHeader(int row, int dataWriterIndex, int startIndex, int length) {
        if (row >= this._headerBuffers.size() * this._rowCountPerChunk) {
            this.addHeaderBuffers();
        }
        this._curHeaderWriter.setInt(this.getRowInCurrentHeader(row), 0, dataWriterIndex);
        this._curHeaderWriter.setInt(this.getRowInCurrentHeader(row), 1, startIndex);
        this._curHeaderWriter.setInt(this.getRowInCurrentHeader(row), 2, length);
    }

    private FixedByteSingleValueMultiColReader getCurrentReader(int row) {
        return this._headerReaders.get(row / this._rowCountPerChunk);
    }

    private int getRowInCurrentHeader(int row) {
        return row % this._rowCountPerChunk;
    }

    private int updateHeader(int row, int numValues) {
        assert (numValues <= this._maxNumberOfMultiValuesPerRow);
        int newStartIndex = this._prevRowStartIndex + this._prevRowLength;
        if (newStartIndex + numValues > this._currentCapacity) {
            this.addDataBuffers(this._incrementalCapacity);
            this._prevRowStartIndex = 0;
            this._prevRowLength = 0;
            newStartIndex = 0;
        }
        this.writeIntoHeader(row, this._currentDataWriterIndex, newStartIndex, numValues);
        this._prevRowStartIndex = newStartIndex;
        this._prevRowLength = numValues;
        return newStartIndex;
    }

    @Override
    public void setCharArray(int row, char[] charArray) {
        int newStartIndex = this.updateHeader(row, charArray.length);
        for (int i = 0; i < charArray.length; ++i) {
            this._currentDataWriter.setChar(newStartIndex + i, 0, charArray[i]);
        }
    }

    @Override
    public void setShortArray(int row, short[] shortsArray) {
        int newStartIndex = this.updateHeader(row, shortsArray.length);
        for (int i = 0; i < shortsArray.length; ++i) {
            this._currentDataWriter.setShort(newStartIndex + i, 0, shortsArray[i]);
        }
    }

    @Override
    public void setIntArray(int row, int[] intArray) {
        int newStartIndex = this.updateHeader(row, intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            this._currentDataWriter.setInt(newStartIndex + i, 0, intArray[i]);
        }
    }

    @Override
    public void setLongArray(int row, long[] longArray) {
        int newStartIndex = this.updateHeader(row, longArray.length);
        for (int i = 0; i < longArray.length; ++i) {
            this._currentDataWriter.setLong(newStartIndex + i, 0, longArray[i]);
        }
    }

    @Override
    public void setFloatArray(int row, float[] floatArray) {
        int newStartIndex = this.updateHeader(row, floatArray.length);
        for (int i = 0; i < floatArray.length; ++i) {
            this._currentDataWriter.setFloat(newStartIndex + i, 0, floatArray[i]);
        }
    }

    @Override
    public void setDoubleArray(int row, double[] doubleArray) {
        int newStartIndex = this.updateHeader(row, doubleArray.length);
        for (int i = 0; i < doubleArray.length; ++i) {
            this._currentDataWriter.setDouble(newStartIndex + i, 0, doubleArray[i]);
        }
    }

    @Override
    public void setStringArray(int row, String[] stringArray) {
        int newStartIndex = this.updateHeader(row, stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this._currentDataWriter.setString(newStartIndex + i, 0, stringArray[i]);
        }
    }

    @Override
    public void setBytesArray(int row, byte[][] bytesArray) {
        int newStartIndex = this.updateHeader(row, bytesArray.length);
        for (int i = 0; i < bytesArray.length; ++i) {
            this._currentDataWriter.setBytes(newStartIndex + i, 0, bytesArray[i]);
        }
    }

    @Override
    public int getCharArray(int row, char[] charArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            charArray[i] = dataReader.getChar(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getShortArray(int row, short[] shortsArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            shortsArray[i] = dataReader.getShort(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getIntArray(int row, int[] intArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            intArray[i] = dataReader.getInt(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getLongArray(int row, long[] longArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            longArray[i] = dataReader.getLong(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getFloatArray(int row, float[] floatArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            floatArray[i] = dataReader.getFloat(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getDoubleArray(int row, double[] doubleArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            doubleArray[i] = dataReader.getDouble(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getStringArray(int row, String[] stringArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            stringArray[i] = dataReader.getString(startIndex + i, 0);
        }
        return length;
    }

    @Override
    public int getBytesArray(int row, byte[][] bytesArray) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(row);
        int rowInCurrentHeader = this.getRowInCurrentHeader(row);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            bytesArray[i] = dataReader.getBytes(startIndex + i, 0);
        }
        return length;
    }
}

