/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.StringUtil;

public class FixedByteSingleValueMultiColWriter {
    private int[] columnOffsets;
    private PinotDataBuffer indexDataBuffer;
    private int rowSizeInBytes;

    public FixedByteSingleValueMultiColWriter(File file, int rows, int cols, int[] columnSizes) throws IOException {
        this.columnOffsets = new int[cols];
        this.rowSizeInBytes = 0;
        for (int i = 0; i < columnSizes.length; ++i) {
            this.columnOffsets[i] = this.rowSizeInBytes;
            int colSize = columnSizes[i];
            this.rowSizeInBytes += colSize;
        }
        int totalSize = this.rowSizeInBytes * rows;
        this.indexDataBuffer = PinotDataBuffer.mapFile(file, false, 0L, totalSize, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
    }

    public FixedByteSingleValueMultiColWriter(PinotDataBuffer dataBuffer, int cols, int[] columnSizes) {
        this.columnOffsets = new int[cols];
        this.rowSizeInBytes = 0;
        for (int i = 0; i < columnSizes.length; ++i) {
            this.columnOffsets[i] = this.rowSizeInBytes;
            int colSize = columnSizes[i];
            this.rowSizeInBytes += colSize;
        }
        this.indexDataBuffer = dataBuffer;
    }

    public boolean open() {
        return true;
    }

    public void setChar(int row, int col, char ch) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.putChar(offset, ch);
    }

    public void setInt(int row, int col, int i) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.putInt(offset, i);
    }

    public void setShort(int row, int col, short s) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.putShort(offset, s);
    }

    public void setLong(int row, int col, long l) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.putLong(offset, l);
    }

    public void setFloat(int row, int col, float f) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.putFloat(offset, f);
    }

    public void setDouble(int row, int col, double d) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.putDouble(offset, d);
    }

    public void setString(int row, int col, String string) {
        this.setBytes(row, col, StringUtil.encodeUtf8(string));
    }

    public void setBytes(int row, int col, byte[] bytes) {
        int offset = this.rowSizeInBytes * row + this.columnOffsets[col];
        this.indexDataBuffer.readFrom((long)offset, bytes);
    }

    public void close() throws IOException {
        this.indexDataBuffer.close();
        this.indexDataBuffer = null;
    }
}

