/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.PinotDataBitSet;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.SingleColumnMultiValueWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedBitMultiValueWriter
implements SingleColumnMultiValueWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedBitMultiValueWriter.class);
    private static int SIZE_OF_INT = 4;
    private static int NUM_COLS_IN_HEADER = 1;
    private static final int PREFERRED_NUM_VALUES_PER_CHUNK = 2048;
    private PinotDataBuffer indexDataBuffer;
    private PinotDataBuffer chunkOffsetsBuffer;
    private PinotDataBuffer bitsetBuffer;
    private PinotDataBuffer rawDataBuffer;
    private FixedByteValueReaderWriter chunkOffsetsWriter;
    private PinotDataBitSet customBitSet;
    private FixedBitIntReaderWriter rawDataWriter;
    private int numChunks;
    int prevRowStartIndex = 0;
    int prevRowLength = 0;
    int prevRowId = -1;
    private int chunkOffsetHeaderSize;
    private int bitsetSize;
    private long rawDataSize;
    private long totalSize;
    private int docsPerChunk;

    public FixedBitMultiValueWriter(File file, int numDocs, int totalNumValues, int columnSizeInBits) throws Exception {
        float averageValuesPerDoc = totalNumValues / numDocs;
        this.docsPerChunk = (int)Math.ceil(2048.0f / averageValuesPerDoc);
        this.numChunks = (numDocs + this.docsPerChunk - 1) / this.docsPerChunk;
        this.chunkOffsetHeaderSize = this.numChunks * SIZE_OF_INT * NUM_COLS_IN_HEADER;
        this.bitsetSize = (totalNumValues + 7) / 8;
        this.rawDataSize = ((long)totalNumValues * (long)columnSizeInBits + 7L) / 8L;
        this.totalSize = (long)(this.chunkOffsetHeaderSize + this.bitsetSize) + this.rawDataSize;
        Preconditions.checkState(this.totalSize > 0L && this.totalSize < Integer.MAX_VALUE, "Total size can not exceed 2GB for file: ", (Object)file.toString());
        this.indexDataBuffer = PinotDataBuffer.mapFile(file, false, 0L, this.totalSize, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
        this.chunkOffsetsBuffer = this.indexDataBuffer.view(0L, this.chunkOffsetHeaderSize);
        int bitsetEndPos = this.chunkOffsetHeaderSize + this.bitsetSize;
        this.bitsetBuffer = this.indexDataBuffer.view(this.chunkOffsetHeaderSize, bitsetEndPos);
        this.rawDataBuffer = this.indexDataBuffer.view(bitsetEndPos, (long)bitsetEndPos + this.rawDataSize);
        this.chunkOffsetsWriter = new FixedByteValueReaderWriter(this.chunkOffsetsBuffer);
        this.customBitSet = new PinotDataBitSet(this.bitsetBuffer);
        this.rawDataWriter = new FixedBitIntReaderWriter(this.rawDataBuffer, totalNumValues, columnSizeInBits);
    }

    public int getChunkOffsetHeaderSize() {
        return this.chunkOffsetHeaderSize;
    }

    public int getBitsetSize() {
        return this.bitsetSize;
    }

    public long getRawDataSize() {
        return this.rawDataSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public int getRowsPerChunk() {
        return this.docsPerChunk;
    }

    @Override
    public void close() throws IOException {
        this.customBitSet.close();
        this.chunkOffsetsWriter.close();
        this.rawDataWriter.close();
        this.indexDataBuffer.close();
        this.chunkOffsetsBuffer = null;
        this.bitsetBuffer = null;
        this.rawDataBuffer = null;
        this.customBitSet = null;
        this.chunkOffsetsWriter = null;
        this.rawDataWriter = null;
    }

    private int updateHeader(int rowId, int length) {
        assert (rowId == this.prevRowId + 1);
        int newStartIndex = this.prevRowStartIndex + this.prevRowLength;
        if (rowId % this.docsPerChunk == 0) {
            int chunkId = rowId / this.docsPerChunk;
            this.chunkOffsetsWriter.writeInt(chunkId, newStartIndex);
        }
        this.customBitSet.setBit(newStartIndex);
        this.prevRowStartIndex = newStartIndex;
        this.prevRowLength = length;
        this.prevRowId = rowId;
        return newStartIndex;
    }

    @Override
    public void setCharArray(int row, char[] charArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setShortArray(int row, short[] shortsArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setIntArray(int row, int[] intArray) {
        this.rawDataWriter.writeInt(this.updateHeader(row, intArray.length), intArray.length, intArray);
    }

    @Override
    public void setLongArray(int row, long[] longArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setFloatArray(int row, float[] floatArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setDoubleArray(int row, double[] doubleArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setStringArray(int row, String[] stringArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setBytesArray(int row, byte[][] bytesArray) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }
}

