/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.FileFormat;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.CompoundTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.common.data.DateTimeFieldSpec;
import org.apache.pinot.common.data.DateTimeFormatSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.data.TimeFieldSpec;
import org.apache.pinot.common.data.TimeGranularitySpec;
import org.apache.pinot.common.segment.StarTreeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackfillDateTimeColumn {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackfillDateTimeColumn.class);
    private final File _originalIndexDir;
    private final File _backfilledIndexDir;
    private final TimeFieldSpec _srcTimeFieldSpec;
    private final DateTimeFieldSpec _destDateTimeFieldSpec;

    public BackfillDateTimeColumn(@Nonnull File originalIndexDir, @Nonnull File backfilledIndexDir, @Nonnull TimeFieldSpec srcTimeSpec, @Nonnull DateTimeFieldSpec destDateTimeSpec) throws Exception {
        this._originalIndexDir = originalIndexDir;
        this._backfilledIndexDir = backfilledIndexDir;
        Preconditions.checkArgument(!this._originalIndexDir.getAbsolutePath().equals(this._backfilledIndexDir.getAbsolutePath()), "Original index dir and backfill index dir should not be the same");
        this._srcTimeFieldSpec = srcTimeSpec;
        this._destDateTimeFieldSpec = destDateTimeSpec;
    }

    public boolean backfill() throws Exception {
        SegmentMetadataImpl originalSegmentMetadata = new SegmentMetadataImpl(this._originalIndexDir);
        String segmentName = originalSegmentMetadata.getName();
        String tableName = originalSegmentMetadata.getTableName();
        LOGGER.info("Start backfilling segment: {} in table: {}", (Object)segmentName, (Object)tableName);
        PinotSegmentRecordReader segmentRecordReader = new PinotSegmentRecordReader(this._originalIndexDir);
        BackfillDateTimeRecordReader wrapperReader = new BackfillDateTimeRecordReader(segmentRecordReader, this._srcTimeFieldSpec, this._destDateTimeFieldSpec);
        LOGGER.info("Segment dir: {} Output Dir: {}", (Object)this._originalIndexDir.getAbsolutePath(), (Object)this._backfilledIndexDir.getAbsolutePath());
        LOGGER.info("Creating segment generator config for {}", (Object)segmentName);
        SegmentGeneratorConfig config = new SegmentGeneratorConfig();
        config.setFormat(FileFormat.PINOT);
        config.setOutDir(this._backfilledIndexDir.getAbsolutePath());
        config.setOverwrite(true);
        config.setTableName(tableName);
        config.setSegmentName(segmentName);
        config.setSchema(wrapperReader.getSchema());
        StarTreeMetadata starTreeMetadata = originalSegmentMetadata.getStarTreeMetadata();
        if (starTreeMetadata != null) {
            config.enableStarTreeIndex(StarTreeIndexSpec.fromStarTreeMetadata(starTreeMetadata));
        }
        LOGGER.info("Creating segment for {} with config {}", (Object)segmentName, (Object)config.toString());
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        driver.init(config, new RecordReaderSegmentCreationDataSource(wrapperReader), CompoundTransformer.getPassThroughTransformer());
        driver.build();
        return true;
    }

    public BackfillDateTimeRecordReader getBackfillDateTimeRecordReader(RecordReader baseRecordReader) {
        return new BackfillDateTimeRecordReader(baseRecordReader, this._srcTimeFieldSpec, this._destDateTimeFieldSpec);
    }

    public class BackfillDateTimeRecordReader
    implements RecordReader {
        private final RecordReader _baseRecordReader;
        private final TimeFieldSpec _timeFieldSpec;
        private final DateTimeFieldSpec _dateTimeFieldSpec;
        private final Schema _schema;

        public BackfillDateTimeRecordReader(RecordReader baseRecordReader, TimeFieldSpec timeFieldSpec, DateTimeFieldSpec dateTimeFieldSpec) {
            this._baseRecordReader = baseRecordReader;
            this._timeFieldSpec = timeFieldSpec;
            this._dateTimeFieldSpec = dateTimeFieldSpec;
            this._schema = baseRecordReader.getSchema();
            this._schema.removeField(this._dateTimeFieldSpec.getName());
            this._schema.addField(this._dateTimeFieldSpec);
        }

        @Override
        public boolean hasNext() {
            return this._baseRecordReader.hasNext();
        }

        @Override
        public GenericRow next() throws IOException {
            return this.next(new GenericRow());
        }

        @Override
        public GenericRow next(GenericRow reuse) throws IOException {
            reuse = this._baseRecordReader.next(reuse);
            Long timeColumnValue = (Long)reuse.getValue(this._timeFieldSpec.getName());
            Object dateTimeColumnValue = this.convertTimeFieldToDateTimeFieldSpec(timeColumnValue);
            reuse.putField(this._dateTimeFieldSpec.getName(), dateTimeColumnValue);
            return reuse;
        }

        private Object convertTimeFieldToDateTimeFieldSpec(Object timeColumnValue) {
            TimeGranularitySpec timeGranularitySpec = this._timeFieldSpec.getOutgoingGranularitySpec();
            DateTimeFormatSpec formatFromTimeSpec = new DateTimeFormatSpec(timeGranularitySpec.getTimeUnitSize(), timeGranularitySpec.getTimeType().toString(), timeGranularitySpec.getTimeFormat());
            if (formatFromTimeSpec.getFormat().equals(this._dateTimeFieldSpec.getFormat())) {
                return timeColumnValue;
            }
            long timeColumnValueMS = timeGranularitySpec.toMillis(timeColumnValue);
            DateTimeFormatSpec toFormat = new DateTimeFormatSpec(this._dateTimeFieldSpec.getFormat());
            return toFormat.fromMillisToFormat(timeColumnValueMS, Object.class);
        }

        @Override
        public void rewind() throws IOException {
            this._baseRecordReader.rewind();
        }

        @Override
        public Schema getSchema() {
            return this._schema;
        }

        @Override
        public void close() throws IOException {
            this._baseRecordReader.close();
        }
    }
}

