/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion;

import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.commons.lang.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockSingleValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SingleValueRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.V1Constants;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.util.CrcUtils;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.segment.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawIndexConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawIndexConverter.class);
    private static final int CONVERSION_THRESHOLD = 4;
    private static final int BITS_PER_ELEMENT_FOR_RAW_INDEX = -1;
    private final ImmutableSegment _originalImmutableSegment;
    private final SegmentMetadataImpl _originalSegmentMetadata;
    private final File _convertedIndexDir;
    private final PropertiesConfiguration _convertedProperties;
    private final String _columnsToConvert;

    public RawIndexConverter(@Nonnull File originalIndexDir, @Nonnull File convertedIndexDir, @Nullable String columnsToConvert) throws Exception {
        FileUtils.copyDirectory(originalIndexDir, convertedIndexDir);
        IndexLoadingConfig indexLoadingConfig = new IndexLoadingConfig();
        indexLoadingConfig.setSegmentVersion(SegmentVersion.v1);
        indexLoadingConfig.setReadMode(ReadMode.mmap);
        this._originalImmutableSegment = ImmutableSegmentLoader.load(originalIndexDir, indexLoadingConfig);
        this._originalSegmentMetadata = (SegmentMetadataImpl)this._originalImmutableSegment.getSegmentMetadata();
        this._convertedIndexDir = convertedIndexDir;
        this._convertedProperties = new PropertiesConfiguration(new File(this._convertedIndexDir, "metadata.properties"));
        this._columnsToConvert = columnsToConvert;
    }

    public boolean convert() throws Exception {
        String segmentName = this._originalSegmentMetadata.getName();
        String tableName = this._originalSegmentMetadata.getTableName();
        LOGGER.info("Start converting segment: {} in table: {}", (Object)segmentName, (Object)tableName);
        ArrayList<FieldSpec> columnsToConvert = new ArrayList<FieldSpec>();
        Schema schema = this._originalSegmentMetadata.getSchema();
        if (this._columnsToConvert == null) {
            LOGGER.info("Columns to convert are not specified, check each metric column");
            for (MetricFieldSpec metricFieldSpec : schema.getMetricFieldSpecs()) {
                if (!this._originalSegmentMetadata.hasDictionary(metricFieldSpec.getName()) || !this.shouldConvertColumn(metricFieldSpec)) continue;
                columnsToConvert.add(metricFieldSpec);
            }
        } else {
            LOGGER.info("Columns to convert: {}", (Object)this._columnsToConvert);
            for (String columnToConvert : StringUtils.split(this._columnsToConvert, ',')) {
                FieldSpec fieldSpec = schema.getFieldSpecFor(columnToConvert);
                if (fieldSpec == null) {
                    LOGGER.warn("Skip converting column: {} because is does not exist in the schema");
                    continue;
                }
                if (!fieldSpec.isSingleValueField()) {
                    LOGGER.warn("Skip converting column: {} because it's a multi-value column");
                    continue;
                }
                if (!this._originalSegmentMetadata.hasDictionary(columnToConvert)) {
                    LOGGER.warn("Skip converting column: {} because its index is not dictionary-based");
                    continue;
                }
                columnsToConvert.add(fieldSpec);
            }
        }
        if (columnsToConvert.isEmpty()) {
            LOGGER.info("No column converted for segment: {} in table: {}", (Object)segmentName, (Object)tableName);
            return false;
        }
        for (FieldSpec columnToConvert : columnsToConvert) {
            this.convertColumn(columnToConvert);
        }
        this._convertedProperties.save();
        SegmentIndexCreationDriverImpl.persistCreationMeta(this._convertedIndexDir, CrcUtils.forAllFilesInFolder(this._convertedIndexDir).computeCrc(), this._originalSegmentMetadata.getIndexCreationTime());
        LOGGER.info("{} columns converted for segment: {} in table: {}", new Object[]{columnsToConvert.size(), segmentName, tableName});
        return true;
    }

    private boolean shouldConvertColumn(FieldSpec fieldSpec) {
        String columnName = fieldSpec.getName();
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        int numTotalDocs = this._originalSegmentMetadata.getTotalDocs();
        ColumnMetadata columnMetadata = this._originalSegmentMetadata.getColumnMetadataFor(columnName);
        int cardinality = columnMetadata.getCardinality();
        int lengthOfEachEntry = dataType.equals((Object)FieldSpec.DataType.STRING) ? columnMetadata.getColumnMaxLength() * 8 : dataType.size() * 8;
        long dictionaryBasedIndexSize = (long)numTotalDocs * (long)columnMetadata.getBitsPerElement() + (long)cardinality * (long)lengthOfEachEntry;
        long rawIndexSize = (long)numTotalDocs * (long)lengthOfEachEntry;
        LOGGER.info("For column: {}, size of dictionary based index: {} bits, size of raw index (without compression): {} bits", new Object[]{columnName, dictionaryBasedIndexSize, rawIndexSize});
        return rawIndexSize <= dictionaryBasedIndexSize * 4L;
    }

    private void convertColumn(FieldSpec fieldSpec) throws Exception {
        String columnName = fieldSpec.getName();
        LOGGER.info("Converting column: {}", (Object)columnName);
        FileUtils.deleteQuietly(new File(this._convertedIndexDir, columnName + ".dict"));
        FileUtils.deleteQuietly(new File(this._convertedIndexDir, columnName + ".sv.unsorted.fwd"));
        FileUtils.deleteQuietly(new File(this._convertedIndexDir, columnName + ".sv.sorted.fwd"));
        FileUtils.deleteQuietly(new File(this._convertedIndexDir, columnName + ".bitmap.inv"));
        DataSource dataSource = this._originalImmutableSegment.getDataSource(columnName);
        Dictionary dictionary = dataSource.getDictionary();
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        int lengthOfLongestEntry = this._originalSegmentMetadata.getColumnMetadataFor(columnName).getColumnMaxLength();
        try (SingleValueRawIndexCreator rawIndexCreator = SegmentColumnarIndexCreator.getRawIndexCreatorForColumn(this._convertedIndexDir, ChunkCompressorFactory.CompressionType.SNAPPY, columnName, dataType, this._originalSegmentMetadata.getTotalDocs(), lengthOfLongestEntry);){
            BlockSingleValIterator iterator = (BlockSingleValIterator)dataSource.nextBlock().getBlockValueSet().iterator();
            int docId = 0;
            while (iterator.hasNext()) {
                int dictId = iterator.nextIntVal();
                rawIndexCreator.index(docId++, dictionary.get(dictId));
            }
        }
        this._convertedProperties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(columnName, "hasDictionary"), false);
        this._convertedProperties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(columnName, "bitsPerElement"), -1);
    }
}

