/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.segment.StarTreeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPurger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPurger.class);
    private final File _originalIndexDir;
    private final File _workingDir;
    private final RecordPurger _recordPurger;
    private final RecordModifier _recordModifier;
    private int _numRecordsPurged;
    private int _numRecordsModified;

    public SegmentPurger(@Nonnull File originalIndexDir, @Nonnull File workingDir, @Nullable RecordPurger recordPurger, @Nullable RecordModifier recordModifier) {
        Preconditions.checkArgument(recordPurger != null || recordModifier != null, "At least one of record purger and modifier should be non-null");
        this._originalIndexDir = originalIndexDir;
        this._workingDir = workingDir;
        this._recordPurger = recordPurger;
        this._recordModifier = recordModifier;
    }

    public File purgeSegment() throws Exception {
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(this._originalIndexDir);
        String tableName = segmentMetadata.getTableName();
        String segmentName = segmentMetadata.getName();
        LOGGER.info("Start purging table: {}, segment: {}", (Object)tableName, (Object)segmentName);
        try (PurgeRecordReader purgeRecordReader = new PurgeRecordReader();){
            StarTreeMetadata starTreeMetadata;
            while (purgeRecordReader.hasNext()) {
                purgeRecordReader.next();
            }
            if (this._numRecordsModified == 0 && this._numRecordsPurged == 0) {
                File file = null;
                return file;
            }
            SegmentGeneratorConfig config = new SegmentGeneratorConfig(purgeRecordReader.getSchema());
            config.setOutDir(this._workingDir.getPath());
            config.setTableName(tableName);
            config.setSegmentName(segmentName);
            config.setCreationTime(String.valueOf(segmentMetadata.getIndexCreationTime()));
            if (segmentMetadata.getTimeInterval() != null) {
                config.setTimeColumnName(segmentMetadata.getTimeColumn());
                config.setStartTime(Long.toString(segmentMetadata.getStartTime()));
                config.setEndTime(Long.toString(segmentMetadata.getEndTime()));
                config.setSegmentTimeUnit(segmentMetadata.getTimeUnit());
            }
            if ((starTreeMetadata = segmentMetadata.getStarTreeMetadata()) != null) {
                config.enableStarTreeIndex(StarTreeIndexSpec.fromStarTreeMetadata(starTreeMetadata));
            }
            SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
            purgeRecordReader.rewind();
            driver.init(config, purgeRecordReader);
            driver.build();
        }
        LOGGER.info("Finish purging table: {}, segment: {}, purged {} records, modified {} records", new Object[]{tableName, segmentName, this._numRecordsPurged, this._numRecordsModified});
        return new File(this._workingDir, segmentName);
    }

    public RecordPurger getRecordPurger() {
        return this._recordPurger;
    }

    public RecordModifier getRecordModifier() {
        return this._recordModifier;
    }

    public int getNumRecordsPurged() {
        return this._numRecordsPurged;
    }

    public int getNumRecordsModified() {
        return this._numRecordsModified;
    }

    public static interface RecordModifier {
        public boolean modifyRecord(GenericRow var1);
    }

    public static interface RecordModifierFactory {
        public RecordModifier getRecordModifier(@Nonnull String var1);
    }

    public static interface RecordPurger {
        public boolean shouldPurge(GenericRow var1);
    }

    public static interface RecordPurgerFactory {
        public RecordPurger getRecordPurger(@Nonnull String var1);
    }

    private class PurgeRecordReader
    implements RecordReader {
        final PinotSegmentRecordReader _recordReader;
        GenericRow _nextRow = new GenericRow();
        boolean _nextRowReturned = true;
        boolean _finished = false;

        PurgeRecordReader() throws Exception {
            this._recordReader = new PinotSegmentRecordReader(SegmentPurger.this._originalIndexDir);
        }

        @Override
        public boolean hasNext() {
            if (SegmentPurger.this._recordPurger == null) {
                return this._recordReader.hasNext();
            }
            if (this._finished) {
                return false;
            }
            if (!this._nextRowReturned) {
                return true;
            }
            while (this._recordReader.hasNext()) {
                this._nextRow = this._recordReader.next(this._nextRow);
                if (SegmentPurger.this._recordPurger.shouldPurge(this._nextRow)) {
                    SegmentPurger.this._numRecordsPurged++;
                    continue;
                }
                this._nextRowReturned = false;
                return true;
            }
            this._finished = true;
            return false;
        }

        @Override
        public GenericRow next() {
            return this.next(new GenericRow());
        }

        @Override
        public GenericRow next(GenericRow reuse) {
            if (SegmentPurger.this._recordPurger == null) {
                reuse = this._recordReader.next(reuse);
            } else {
                Preconditions.checkState(!this._nextRowReturned);
                for (Map.Entry<String, Object> entry : this._nextRow.getEntrySet()) {
                    reuse.putField(entry.getKey(), entry.getValue());
                }
                this._nextRowReturned = true;
            }
            if (SegmentPurger.this._recordModifier != null && SegmentPurger.this._recordModifier.modifyRecord(reuse)) {
                SegmentPurger.this._numRecordsModified++;
            }
            return reuse;
        }

        @Override
        public void rewind() {
            this._recordReader.rewind();
            this._nextRowReturned = true;
            this._finished = false;
            SegmentPurger.this._numRecordsPurged = 0;
            SegmentPurger.this._numRecordsModified = 0;
        }

        @Override
        public Schema getSchema() {
            return this._recordReader.getSchema();
        }

        @Override
        public void close() throws IOException {
            this._recordReader.close();
        }
    }
}

